% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ScatterHistC.R
\name{ScatterHistN}
\alias{ScatterHistN}
\title{Plot a height scatter plot with marginals.}
\usage{
ScatterHistN(frame, xvar, yvar, zvar, title, ..., annot_size = 3,
  colorPalette = "RdYlBu", nclus = 3, adjust_x = 1, adjust_y = 1)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the x variable}

\item{yvar}{name of the y variable}

\item{zvar}{name of height variable}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{annot_size}{numeric: scale annotation text (if present)}

\item{colorPalette}{name of a Brewer palette (see http://colorbrewer2.org/ )}

\item{nclus}{scalar: number of z-clusters to plot}

\item{adjust_x}{numeric: adjust x density plot}

\item{adjust_y}{numeric: adjust y density plot}
}
\description{
Plot a scatter plot conditioned on a continuous variable, with marginal conditional density plots.
}
\details{
\code{xvar} and \code{yvar} are the coordinates of the points, and \code{zvar} is the
continuous conditioning variable. \code{zvar} is partitioned into \code{nclus} disjoint
ranges (by default, 3), which are then treated as discrete categories.The scatterplot and marginal density plots
are color-coded by these categories.
}
\examples{

set.seed(34903490)
frm = data.frame(x=rnorm(50),y=rnorm(50))
frm$z <- frm$x+frm$y
WVPlots::ScatterHistN(frm, "x", "y", "z", title="Example Joint Distribution")

}
\seealso{
\code{\link{ScatterHistC}}
}
