% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AddVariables.R
\name{AddVariables}
\alias{AddVariables}
\title{AddVariables}
\usage{
AddVariables(server, username, password, variables)
}
\arguments{
\item{server}{The URL of the web service ending with /services or with ?wsdl,
for example: http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx?wsdl
alternatively you can specify the JSON API url like:
http://worldwater.byu.edu/app/index.php/default/services/api/}

\item{username}{The valid HydroServer Lite username, for example "admin"}

\item{password}{The valid HydroServer Lite password, for example "password"}

\item{variables}{The valid table of variables. This table must have the following columns:
VariableCode, VariableName, Speciation, VariableUnitsID, SampleMedium, ValueType,
IsRegular, TimeSupport, TimeUnitsID, DataType, GeneralCategory, NoDataValue.
NOTE that the values of these fields must be in the CUAHSI controlled vocabulary.}
}
\value{
A table of the added variables, with two extra columns:
VariableID (the ID assigned by the server),
Status (the status showing if the variable was added: OK or Error). If the status is Error, then
the Error message with reason why the variable could not be added is also shown.
}
\description{
This function adds a table of variables to HydroServer Lite.
The input must be a data.frame with all required ODM 'variable' fields
NOTE: this only works with HydroServer Lite that implements the JSON API.
you must specify a valid server url, user name, and password for the HydroServer.
The examples here use the 'sandbox' HydroServer on http://worldwater.byu.edu/app/
with the username: admin and password: password.
}
\examples{
user <- "admin"
pass <- "password"
server <- "http://worldwater.byu.edu/app/index.php/default/services/cuahsi_1_1.asmx"
#make random site codes
random_code = sprintf("R-\%04d",sample(1:10000, 1))
my_variables <- data.frame(
  VariableCode = random_code,
  VariableName = "Color",
  Speciation = "Not Applicable",
  VariableUnitsID = 189,
  SampleMedium = "Groundwater",
  ValueType = "Sample",
  IsRegular = 1,
  TimeSupport = 0,
  TimeUnitsID = 100,
  DataType = "Average",
  GeneralCategory = "Hydrology",
  NoDataValue = -9999
)

added_variables <- AddVariables(server, username=user, password=pass,
                                variables=my_variables)
}
\keyword{waterml}

