% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve2time.R
\name{curve2time}
\alias{curve2time}
\title{Convert the tracked curve to a depth time space}
\usage{
curve2time(
  tracked_cycle_curve = NULL,
  tracked_cycle_period = NULL,
  genplot = FALSE,
  keep_editable = FALSE
)
}
\arguments{
\item{tracked_cycle_curve}{Curve of the cycle tracked using the
\code{\link{track_period_wavelet}} function \cr
Any input (matrix or data frame) in which the first column is depth in
 meters and the second column is period in meters can be used.}

\item{tracked_cycle_period}{Period of the tracked curve in kyr.}

\item{genplot}{Generates a plot with depth vs time \code{Default=FALSE}.}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
The output is a matrix with 2 columns.
The first column is depth.
The second column sedimentation rate in cm/kyr.
If \code{genplot=TRUE} then a depth vs time plot will be plotted.
}
\description{
Converts the tracked curve to a depth time space.
}
\examples{
\donttest{
#Convert a tracked curve to a depth time space. The examples uses the
#magnetic susceptibility data set of Pas et al., (2018).

#'# perform the CWT
mag_wt <- analyze_wavelet(data = mag,
dj = 1/100,
lowerPeriod = 0.1,
upperPeriod = 254,
verbose = FALSE,
omega_nr = 10)

#Track the 405 kyr eccentricity cycle in a wavelet spectra

#mag_track <- track_period_wavelet(astro_cycle = 405,
#                                   wavelet=mag_wt,
#                                   n.levels = 100,
#                                   periodlab = "Period (metres)",
#                                   x_lab = "depth (metres)")

#Instead of tracking, the tracked solution data set mag_track_solution is used
mag_track <- mag_track_solution

mag_track_complete <- completed_series(
  wavelet = mag_wt,
  tracked_curve = mag_track,
  period_up = 1.2,
  period_down = 0.8,
  extrapolate = TRUE,
  genplot = FALSE
)

# smooth the tracking of the 405 kyr eccentricity cycle
mag_track_complete <- loess_auto(time_series = mag_track_complete,
genplot = FALSE, print_span = FALSE)

#convert period in meters to sedrate depth vs time
mag_track_time<- curve2time(tracked_cycle_curve=mag_track_complete,
tracked_cycle_period=405,
genplot=FALSE,
keep_editable=FALSE)

}
}
\references{
Routines for astrochronologic testing, astronomical time scale construction, and
time series analysis <doi:10.1016/j.earscirev.2018.11.015>
}
\author{
Based on the \link[astrochron]{sedrate2time}
function of the 'astrochron' R package
}
