% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.mc.sem.basic}
\alias{wp.mc.sem.basic}
\title{Statistical Power Analysis for Structural Equation Modeling / Mediation based on Monte Carlo Simulation}
\usage{
wp.mc.sem.basic(model, indirect = NULL, nobs = 100, nrep = 1000,
  alpha = 0.95, skewness = NULL, kurtosis = NULL, ovnames = NULL,
  se = "default", estimator = "default", parallel = "no",
  ncore = Sys.getenv("NUMBER_OF_PROCESSORS"), cl = NULL, ...)
}
\arguments{
\item{model}{Model specified using lavaan syntax. More about model specification can be found in \cite{Rosseel (2012)}.}

\item{indirect}{Indirect effect difined using lavaan syntax.}

\item{nobs}{Sample size.}

\item{nrep}{Number of replications for the Monte Carlo simulation.}

\item{alpha}{significance level chosed for the test. It equals 0.05 by default.}

\item{skewness}{A sequence of skewnesses of the observed variables.}

\item{kurtosis}{A sequence of kurtosises of the observed variables.}

\item{ovnames}{Names of the observed variables in the model.}

\item{se}{The method for calculatating the standard errors. Its default method "default" is regular standard errors.
More about methods specification standard errors calculatationcan be found in \cite{Rosseel (2012)}.}

\item{estimator}{Estimator. It is Maxmum likelihood estimator by default. More about estimator specification can be found in \cite{Rosseel (2012)}.}

\item{parallel}{Parallel computing (\code{"no"} or \code{"parallel"} or \code{"snow"}). It is "no" by default, which means it will not use parallel computing.
The option "parallel" is to use multiple cores in a computer for parallel computing. It is used with the number of cores (\cite{ncore}).
The option "snow" is to use clusters for parallel computing. It is used with the number of clusters (\cite{cl}).}

\item{ncore}{Number of processors used for parallel computing. By default, ncore = Sys.getenv('NUMBER_OF_PROCESSORS').}

\item{cl}{Number of clusters. It is NULL by default. When it is NULL, the program will detect the number of clusters automatically.}

\item{...}{Extra arguments. It is not required.}
}
\value{
An object of the power analysis. The power for all parameters in the model as well as the indirect effects if specified.
}
\description{
Structural equation modeling (SEM) is a multivariate technique used to analyze relationships among observed and latent variables.
It can be viewed as a combination of factor analysis and multivariate regression analysis. A mediation model can be viewed as a SEM model.
Funtions \cite{wp.sem.chisq} and \cite{wp.sem.rmsea} provide anlytical solutions of power analysis for SEM.
Function \cite{wp.mediation} provides anlytical solutions of power analysis for a simple mediatoin model.
This function provides a solution based on Monte Carlo simulation (see \cite{Zhang, 2014}). If the model is a mediation, Sobel test is used for the mediation / indirect effects.
The solution is extended from the general framework for power analysis for complex mediation models using Monte Carlo simulation in Mplus \cite{(Muthén & Muthén, 2011)} proposed by \cite{Thoemmes et al. (2010)}.
We extended the framework in two ways. 
First, the method allows the specification of nonnormal data in the Monte Carlo simulation and can thereby reflect more closely practical data collection.
Second, the function \cite{wp.mc.sem.basic} of a free, open-source R package, WebPower, is developed to ease power anlysis for mediation models using the proposed method.
}
\examples{
\dontrun{
#To calculate power for mediation based on Monte Carlo simulation when Sobel test is used:
#To specify the model
demo ="
		y ~ cp*x + start(0)*x + b*m + start(0.39)* m
		m ~ a*x + start(0.39)*x
		x ~~ start(1)*x
		m ~~ start(1)*m
		y ~~ start(1)*y
	"
#To specify the indirect effects
mediation = "
		ab := a*b
		abc:= a*b + cp
" 
#To calculate power for mediation using regular standard errors
sobel.regular = wp.mc.sem.basic(model=demo, indirect=mediation, nobs=100, nrep=1000,
       parallel="snow", skewness=c(0, 0, 1.3), kurtosis=c(0,0,10), ovnames=c("x","m","y"))

#To calculate power for mediation using robust standard errors
sobel.robust = wp.mc.sem.basic(model=demo, indirect=mediation, nobs=100, nrep=1000,
   parallel="snow", skewness=c(0, 0, 1.3), kurtosis=c(0,0,10), ovnames=c("x","m","y"), se="robust")

#To print the power for mediation based on Sobel test using regular standard errors:
summary(sobel.regular)
#    Basic information:
#    
#      Esimation method                                  ML
#      Standard error                              standard
#      Number of requested replications                1000
#      Number of successful replications               1000
#    
#                           True  Estimate      MSE      SD     Power Coverage
#    Regressions:
#      y ~
#        x        (cp)      0.000    0.003    0.106    0.107    0.045    0.955
#        m         (b)      0.390    0.387    0.099    0.113    0.965    0.919
#      m ~
#        x         (a)      0.390    0.389    0.100    0.101    0.976    0.953
#    Variances:
#        x                  1.000    0.995    0.141    0.139    1.000    0.936
#        m                  1.000    0.981    0.139    0.137    1.000    0.923
#        y                  1.000    0.968    0.137    0.330    1.000    0.560
#    
#    Indirect/Mediation effects:
#        ab                 0.152    0.150    0.056    0.060    0.886    0.928
#        abc                0.152    0.153    0.106    0.109    0.305    0.948

#To print the power analysis results for mediation based on Sobel test using robust standard errors:
summary(sobel.robust)
#    Basic information:
#    
#      Esimation method                                  ML
#      Standard error                            robust.sem
#      Number of requested replications                1000
#      Number of successful replications               1000
#    
#                           True  Estimate      MSE      SD     Power Coverage
#    Regressions:
#      y ~
#        x        (cp)      0.000   -0.003    0.106    0.113    0.055    0.945
#        m         (b)      0.390    0.398    0.111    0.119    0.972    0.927
#      m ~
#        x         (a)      0.390    0.389    0.099    0.101    0.974    0.939
#    
#    Intercepts:
#        y                  0.000    0.000    0.100    0.104    0.058    0.942
#        m                  0.000    0.000    0.100    0.105    0.054    0.946
#        x                  0.000   -0.004    0.100    0.104    0.066    0.934
#    
#    Variances:
#        x                  1.000    0.991    0.138    0.140    1.000    0.930
#        m                  1.000    0.976    0.135    0.135    1.000    0.915
#        y                  1.000    1.002    0.281    0.365    0.981    0.805
#    
#    Indirect/Mediation effects:
#        ab                 0.152    0.156    0.060    0.064    0.870    0.900
#        abc                0.152    0.153    0.108    0.117    0.303    0.936
}

}
\references{
MacCallum, R. C., Browne, M. W., & Sugawara, H. M. (1996). Power analysis and determination of sample size for covariance structure modeling. Psychological methods, 1(2), 130.

Rosseel, Y. (2012). Lavaan: An R package for structural equation modeling and more. Version 0.5–12 (BETA). Ghent, Belgium: Ghent University.

Satorra, A., & Saris, W. E. (1985). Power of the likelihood ratio test in covariance structure analysis. Psychometrika, 50(1), 83-90.

Thoemmes, F., MacKinnon, D. P., & Reiser, M. R. (2010). Power analysis for complex mediational designs using Monte Carlo methods. Structural Equation Modeling, 17(3), 510-534.

Zhang, Z. (2014). Monte Carlo based statistical power analysis for mediation models: Methods and software. Behavior research methods, 46(4), 1184-1198.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
