% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly_rga.R
\name{plotly_rga}
\alias{plotly_rga}
\title{Interactive Reliability Growth Plot.}
\usage{
plotly_rga(
  rga_obj,
  showConf = TRUE,
  showGrid = TRUE,
  main = "Reliability Growth Plot",
  xlab = "Cumulative Time",
  ylab = "Cumulative Failures",
  pointCol = "black",
  fitCol = "black",
  confCol = "black",
  gridCol = "lightgray",
  breakCol = "black"
)
}
\arguments{
\item{rga_obj}{An object of class 'rga'.}

\item{showConf}{Show the confidence bounds (TRUE) or not (FALSE).}

\item{showGrid}{Show grid (TRUE) or hide grid (FALSE).}

\item{main}{Main title.}

\item{xlab}{X-axis label.}

\item{ylab}{Y-axis label.}

\item{pointCol}{Color of the point values.}

\item{fitCol}{Color of the model fit.}

\item{confCol}{Color of the confidence bounds.}

\item{gridCol}{Color of the grid.}

\item{breakCol}{Color of the breakpoints.}
}
\value{
The function returns no value.
}
\description{
Interactive Reliability Growth Plot.
}
\examples{
library(ReliaGrowR)
times<-c(100, 200, 300, 400, 500)
failures<-c(1, 2, 1, 3, 2)
rga<-rga(times, failures)
plotly_rga(rga)
}
