\name{FMbounds}
\alias{FMbounds}

\title{Fisher Matrix bounds}

\description{
 Generates the asymptotic bounds by means of the information matrix.}

\usage{
FMbounds(x, dist="weibull", CI=.90, unrel=NULL, debias="none", show=FALSE)
}

\arguments{
  \item{x}{A dataframe such as generated by mleframe with column names 'left', 'right' and optionally 'qty'.
    Exact failure data (occurrences) have same time entered in both 'left' and 'right' columns.
	Suspension data has last known life[time] entered in 'left' column and -1 entered in 'right' column.
	The left(early) interval bound for left-censored data must be entered as zero. (NA is not accepted).
  }
  \item{dist}{A string defining a distribution to be fit. Implemented distributions are "weibull" (default) and "lognormal".
  (Only 2-parameter models are accepted.)
  }
  \item{CI}{A scalar for the double-sided confidence interval of interest. Default = 0.9, for 90% double-sided bounds.
  }
  \item{unrel}{An optional vector of unreliability values to be used as the descriptive quantiles at which the bounds will be calculated.
  }
  \item{debias}{A string argument indicating the adjustment to be applied to the shape or standard deviation
  parameter of the fitted data.
  }
   \item{show}{A logical determining whether a crude graphic of the bounds shall be displayed.
  } 
}

\value{
  Returns a dataframe holding values of percentiles, lower, datum, and upper values of the bound.
}

\details{
  An "observed" information matrix is derived numerically as the hessian by means of optimHess.  From the variance-covariance matrix (inverse of the hessian) variation of life(-time) at given quantiles is determined.
  
  Application of a bias adjustment alters the calculation of the hessian, thus the bounds are based on a "modified" Fisher Matrix.

}

\references{
  William Q. Meeker and Luis A. Escobar, (1998) "Statistical Methods for Reliability Data", Wiley-Interscience, New York

  Robert B. Abernethy, (2008) "The New Weibull Handbook, Fifth Edition" 
  
  John I. McCool, (2012) "Using the Weibull Distribution: Reliability, Modeling and Inference"
}

\examples{
set.seed(4321)
data<-rlnorm(30,2,1.2)
asymptotic_bounds<-FMbounds(mleframe(data[7:30],data[1:6]), dist="lognormal")
}

\keyword{ regression reliability }