% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HC.R
\name{HC}
\alias{HC}
\title{Run the Hahn-Carvalho Method}
\usage{
HC(
  X,
  Y = NULL,
  theta,
  family = "gaussian",
  penalty = c("elastic.net", "selection.lasso", "lasso", "ols", "mcp", "scad", "mcp.net",
    "scad.net", "grp.lasso", "grp.lasso.net", "grp.mcp", "grp.scad", "grp.mcp.net",
    "grp.scad.net", "sparse.grp.lasso"),
  method = c("selection.variable", "projection"),
  lambda = numeric(0),
  nlambda = 100L,
  lambda.min.ratio = NULL,
  alpha = 1,
  gamma = 1,
  tau = 0.5,
  groups = numeric(0),
  penalty.factor = NULL,
  group.weights = NULL,
  maxit = 500L,
  tol = 1e-07,
  irls.maxit = 100L,
  irls.tol = 0.001
)
}
\arguments{
\item{X}{Covariates}

\item{Y}{Predictions}

\item{theta}{Parameters}

\item{family}{Family for method. See \link[oem]{oem}.}

\item{penalty}{Penalty function. See \link[oem]{oem}.}

\item{method}{Should we run a selection variable methodology or projection?}

\item{lambda}{lambda for lasso. See \link[oem]{oem} for this and all options below}

\item{nlambda}{Number of lambda values.}

\item{lambda.min.ratio}{Minimum lambda ratio for self selected lambda}

\item{alpha}{elastic net mixing.}

\item{gamma}{tuning parameters for SCAD and MCP}

\item{tau}{mixing parameter for sparse group lasso}

\item{groups}{A vector of grouping values}

\item{penalty.factor}{Penalty factor for OEM.}

\item{group.weights}{Weights for groupped lasso}

\item{maxit}{Max iteration for OEM}

\item{tol}{Tolerance for OEM}

\item{irls.maxit}{IRLS max iterations for OEM}

\item{irls.tol}{IRLS tolerance for OEM}
}
\value{
a \code{WpProj} object with selected covariates and their values
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Runs the Hahn-Carvalho method but adapted to return full distributions.
}
\examples{
n <- 32
p <- 10
s <- 99
x <- matrix( 1, nrow = n, ncol = p )
beta <- (1:10)/10
y <- x \%*\% beta
post_beta <- matrix(beta, nrow=p, ncol=s) 
post_mu <- x \%*\% post_beta

fit <-  HC(X=x, Y=post_mu, theta = post_beta,
               penalty = "lasso", 
               method = "projection"
)
}
\references{
Hahn, P. Richard and Carlos M. Carvalho. (2014) "Decoupling Shrinkage and Selection in Bayesian Linear Models: A Posterior Summary Perspective." \url{https://arxiv.org/pdf/1408.0464.pdf}
}
