% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xCheckParallel.r
\name{xCheckParallel}
\alias{xCheckParallel}
\title{Function to check whether parallel computing should be used and how}
\usage{
xCheckParallel(multicores = NULL, verbose = T)
}
\arguments{
\item{multicores}{an integer to specify how many cores will be
registered as the multicore parallel backend to the 'foreach' package.
If NULL, it will use a half of cores available in a user's computer}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
TRUE for using parallel computing; FALSE otherwise
}
\description{
\code{xCheckParallel} is used to check whether parallel computing
should be used and how
}
\note{
Whether parallel computation with multicores is used is
system-specific. Also, it will depend on whether these two packages
"foreach" and "doParallel" have been installed. It can be installed
via: \code{source("http://bioconductor.org/biocLite.R");
biocLite(c("foreach","doParallel"))}.
}
\examples{
xCheckParallel(multicores=2)
}
\seealso{
\code{\link{xDAGsim}}, \code{\link{xSocialiser}},
\code{\link{xGRviaGenomicAnnoAdv}}
}

