/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.integration.r;

import com.miraisolutions.xlconnect.data.Column;
import com.miraisolutions.xlconnect.data.DataFrame;
import com.miraisolutions.xlconnect.data.DataType;
import java.util.ArrayList;
import java.util.Date;

public final class RDataFrameWrapper {
    final DataFrame dataFrame;

    public RDataFrameWrapper() {
        this.dataFrame = new DataFrame();
    }

    public RDataFrameWrapper(DataFrame dataFrame) {
        this.dataFrame = dataFrame;
    }

    public void addNumericColumn(String name, double[] column, boolean[] na) {
        this.dataFrame.addColumn(name, new Column(column, na, DataType.Numeric));
    }

    public void addBooleanColumn(String name, boolean[] column, boolean[] na) {
        this.dataFrame.addColumn(name, new Column(column, na, DataType.Boolean));
    }

    public void addStringColumn(String name, String[] column, boolean[] na) {
        this.dataFrame.addColumn(name, new Column(column, na, DataType.String));
    }

    public void addDateTimeColumn(String name, long[] column, boolean[] na) {
        Date[] elements = new Date[column.length];
        for (int i = 0; i < column.length; ++i) {
            elements[i] = na[i] ? null : new Date(column[i]);
        }
        this.dataFrame.addColumn(name, new Column(elements, na, DataType.DateTime));
    }

    public String[] getColumnTypes() {
        ArrayList<DataType> columnTypes = this.dataFrame.getColumnTypes();
        String[] dataTypes = new String[columnTypes.size()];
        for (int i = 0; i < columnTypes.size(); ++i) {
            dataTypes[i] = columnTypes.get(i).toString();
        }
        return dataTypes;
    }

    public String[] getColumnNames() {
        ArrayList<String> columnNames = this.dataFrame.getColumnNames();
        return columnNames.toArray(new String[columnNames.size()]);
    }

    public double[] getNumericColumn(int col) {
        return this.dataFrame.getColumn(col).getNumericData();
    }

    public String[] getStringColumn(int col) {
        return this.dataFrame.getColumn(col).getStringData();
    }

    public boolean[] getBooleanColumn(int col) {
        return this.dataFrame.getColumn(col).getBooleanData();
    }

    public long[] getDateTimeColumn(int col) {
        Date[] v = this.dataFrame.getColumn(col).getDateTimeData();
        long[] values = new long[v.length];
        for (int i = 0; i < v.length; ++i) {
            values[i] = v[i] == null ? 0L : v[i].getTime();
        }
        return values;
    }

    public boolean[] isMissing(int col) {
        return this.dataFrame.getColumn(col).getMissing();
    }
}

