% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJuliaConnect.R
\docType{class}
\name{JuliaInterface-class}
\alias{JuliaInterface-class}
\alias{JuliaInterface}
\title{An Interface to Julia}
\description{
The JuliaInterface class provides an evaluator for computations in Julia, following the structure
in the XR  package.  Proxy functions and classes allow use of the interface with no explicit
reference to the evaluator.  The function \code{RJulia()} returns an evaluator object.
}
\section{Fields}{

\describe{
\item{\code{port,host}}{The parameters for communicating with the Julia evaluator.}

\item{\code{julia\_bin}}{The command for starting a Julia process.}

\item{\code{connection}}{The connection object through which commands are sent to Julia}
}}

\section{Methods}{

\describe{
\item{\code{Import(module, ...)}}{Import the module.  The "Interface" method assumes a command "import" in the server
language and does not handle any extra arguments (e.g., for importing specific members).}

\item{\code{initialize(...)}}{initializes the evaluator in a language-independent sense.}

\item{\code{ProxyClassName(serverClass)}}{If there is a proxy class defined corresponding to this serverClass, return the name
of that class (typically pasted with the server langauge, separated by underscore).  If no
such class is defined, return NA.}

\item{\code{ServerClassDef(Class, module, ...)}}{Individual interface packages will define this to return a named list or other object such that value$fields and value$methods are the server fields and methods, character vectors
of names or named objects whose elements give further information.  This default version
returns NULL, indicating that no metadata is available.}

\item{\code{ServerEval(expr, key, get)}}{Must be defined by the server language interface: evaluates `expr`(a text string).
If `key` is an empty string, `expr` is treated as a directive, with no defined value.
Otherwise, `key` is a non-empty string, and the server
object should be assigned with this name. The value returned is the R result, which may
be an AssignedProxy() object. If `get` is TRUE or the value judged simple enough,
it will be converted to an ordinary R object instead.}

\item{\code{ServerRemove(key)}}{Should be defined by the server language interface:
    The reference previously created for `key` should be removed.
What happens has no effect on the client side; the intent is to potentially recover memory.}

\item{\code{ServerTask(task, expr, key = "", get = NA)}}{Call the task operation in the Julia code for the interface; the arguments must
be the simple strings or logical value expected.}

\item{\code{Source(filename)}}{Parse and evaluate the contents of the file.  This method is likely to be overriden for particular langauges
with a directive to include the contents of the file.  The `XR` version reads the file and processes the entire contents
as a single string, newlines inserted between lines of the file.}

\item{\code{Using(...)}}{The Julia "using" form of importing.  Arguments are module names.  All the exported
members of these modules will then be available, without prefix.}
}}

