% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJuliaConnect.R
\name{functions}
\alias{functions}
\alias{juliaSource}
\alias{juliaAddToPath}
\alias{juliaUsing}
\alias{juliaImport}
\alias{juliaSend}
\alias{juliaGet}
\alias{juliaPrint}
\alias{juliaEval}
\alias{juliaCommand}
\alias{juliaCall}
\alias{juliaSerialize}
\alias{juliaUnserialize}
\alias{juliaName}
\alias{juliaImport}
\title{Function Versions of Methods for Julia Interface evaluators.}
\usage{
juliaSource(..., evaluator = RJulia())

juliaAddToPath(directory = "julia",
  package = utils::packageName(topenv(parent.frame())), pos = NA,
  evaluator = RJulia(.makeNew = FALSE), where = topenv(parent.frame()))

juliaUsing(module, evaluator)

juliaImport(..., evaluator)

juliaSend(object, evaluator = XR::getInterface(.JuliaInterfaceClass))

juliaGet(object, evaluator = XR::getInterface(.JuliaInterfaceClass))

juliaPrint(object, ..., evaluator = XRJulia::RJulia())

juliaEval(expr, ..., evaluator = XR::getInterface(.JuliaInterfaceClass))

juliaCommand(expr, ..., evaluator = XR::getInterface(.JuliaInterfaceClass))

juliaCall(expr, ..., evaluator = XR::getInterface(.JuliaInterfaceClass))

juliaSerialize(object, file, append = FALSE,
  evaluator = XR::getInterface(.JuliaInterfaceClass))

juliaUnserialize(file, all = FALSE,
  evaluator = XR::getInterface(.JuliaInterfaceClass))

juliaName(object)

juliaImport(..., evaluator)
}
\arguments{
\item{...}{arguments to the corresponding method for an evaluator object.}

\item{evaluator}{The evaluator object to use.  By default, and usually, the current evaluator
is used, and one is started if none has been.  But see the note under \code{juliaImport} for the load actions created in special cases.}

\item{directory}{the directory to add, defaults to "julia"}

\item{package, pos}{arguments to the method, usually omitted.}

\item{where}{for the load action, omitted if called from a package source file.
Otherwise, must be the environment in which a load action can take place.}

\item{module}{String identifying a Julia module.}

\item{object}{A proxy in R for a Julia object.}

\item{expr}{A string that should be legal when parsed and evaluated in Julia.}

\item{file, append, all}{Arguments to the evalutor's serialize and unserialize methods. See the reference,
Chapter 10.}
}
\description{
Function Versions of Methods for Julia Interface evaluators.
}
\section{Functions}{
\itemize{
\item \code{juliaSource}: evaluate the file of Julia source.

\item \code{juliaAddToPath}: adds the directory specified to the search path for Julia modules.
If called from the source directory of a package during installation, sets up
a load action for that package.  If you want to add the path to all
evaluators in \emph{this} session, call the function before creating an evaluator.
Otherwise, the action applies only to the specified evaluator or,
by default, to the current evaluator.

\item \code{juliaUsing}: the "using" form of Julia imports:  the module is imported with all exports exposed.

\item \code{juliaImport}: adds the module information specified to the modules imported for future Julia evaluator objects.

Add the module to the table of imports for Julia evaluators, and import it to the current evaluator
if there is one.
If called from the source directory of a package during installation, both \code{juliaImport}
and \code{juliaAddToPath()} set up
a load action for that package.  The functional versions, not the methods themselves, should
be called from package source files to ensure that the load actions are created.
Note that calling either function before any evaluator has been generated
will install that call as a setup action for all XRJulia evaluators.

\item \code{juliaSend}: sends the \code{object} to Julia, converting it via methods for
\code{\link[XR]{asServerObject}} and returns a proxy for the converted object.

\item \code{juliaGet}: converts the proxy object that is its argument to an \R{} object.

\item \code{juliaPrint}: Print an object in Julia.  Either one object or several arguments as would
be given to the Eval() method.

\item \code{juliaEval}: evaluates the \code{expr} string subsituting the arguments.  See the corresponding evaluator
method for details.

\item \code{juliaCommand}: evaluates the \code{expr} string subsituting the arguments; used for a command that is not
an expression.

\item \code{juliaCall}: call the function in Julia, with arguments given; expr is the string name of the function

\item \code{juliaSerialize}: serialize the \code{object} in Julia

\item \code{juliaUnserialize}: unserialize the file in Julia

\item \code{juliaName}: return the name by which this proxy object was assigned in Julia

\item \code{juliaImport}: Import a Julia module or add a directory to the Julia Search Path
If called from the source directory of a package during installation, both \code{juliaImport}
and \code{juliaAddToPath()} also set up
a load action for that package.  The functional versions, not the methods themselves, should
be called from package source files to ensure that the load actions are created.
}}

