% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Palindromic.Squares.R
\name{Palindromic.Squares}
\alias{Palindromic.Squares}
\alias{A002779}
\title{Palindromic squares}
\usage{
Palindromic.Squares(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A002779}{A002779}, a \emph{Palindromic square} is a number that is
both Palindromic and Square. First 6 such numbers are 0, 1, 4, 9, 121, 484. It uses only the base 10 decimals.
}
\examples{
## generate first 10 palindromic squares
first10 = Palindromic.Squares(10)

## print without trailing 0's.
print(first10, drop0trailing = TRUE)

}
