% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aSPUpathSingle.r
\name{aSPUpathSingle}
\alias{aSPUpathSingle}
\title{Single-gene based version of the Sum of Powered Score tests (SPUpathSingle) and adaptive SPUpathSingle (aSPUpathSingle) test.}
\usage{
aSPUpathSingle(Y, X, cov = NULL, model = c("binomial", "gaussian"),
  snp.info, gene.info, pow = 1:8, n.perm = 200, usePCs = F,
  varprop = 0.95)
}
\arguments{
\item{Y}{Response or phenotype data. It can be a disease indicator; =0 for controls, =1 for cases.
Or it can be a quantitative trait. A vector with length n (number of observations).}

\item{X}{Genotype or other data; each row for a subject, and each column
    for an SNP (or a predictor). The value of each SNP is the # of the copies
    for an allele. A matrix with dimension n by p (n : number of observation, p : number of SNPs (or predictors) ).}

\item{cov}{Covariates. A matrix with dimension n by k (n :number of observation, k : number of covariates).}

\item{model}{Use "gaussian" for a quantitative trait, and use "binomial" for a binary trait.}

\item{snp.info}{SNP information matrix, the 1st column is SNP id, 2nd column is chromosome #, 3rd column indicates SNP location.}

\item{gene.info}{GENE information matrix, The 1st column is GENE id, 2nd column is chromosome #, 3rd and 4th column indicate start and end positions of the gene.}

\item{pow}{SNP specific power(gamma values) used in SPUpath test.}

\item{n.perm}{number of permutations.}

\item{usePCs}{indicating whether to extract PCs and then use PCs of X.}

\item{varprop}{the proportion of the variations explained (cutoff) that
                determines how many top PCs to use.}
}
\value{
P-values for SPUpathSingle tests and aSPUpathSingle test.
}
\description{
It gives p-values of the SPUpathSingle tests and aSPUpathSingle test. We considered applying SPU and aSPU tests to each gene, then using the minimum p-value to combine their p-values.
}
\examples{
\dontrun{dat1<-simPathAR1Snp(nGenes=20, nGenes1=5, nSNPlim=c(1, 20), nSNP0=1,
                    LOR=.2, n=100, MAFlim=c(0.05, 0.4), p0=0.05 ) }
\dontshow{dat1<-simPathAR1Snp(nGenes=20, nGenes1=5, nSNPlim=c(1, 20), nSNP0=1,
                    LOR=.2, n=30, MAFlim=c(0.05, 0.4), p0=0.05 ) }

# p-values of SPUpathSingle and aSPUpathSingle tests.
\dontrun{p.pathaspusingle<- aSPUpathSingle(dat1$Y, dat1$X,
                     snp.info = dat1$snp.info,
                     gene.info = dat1$gene.info,
                     model = "binomial", pow=1:8, n.perm=100)}
\dontshow{p.pathaspusingle<- aSPUpathSingle(dat1$Y, dat1$X,
                     snp.info = dat1$snp.info,
                     gene.info = dat1$gene.info,
                     model = "binomial", pow=1:8, n.perm=20) }
p.pathaspusingle
## pow = 1:8
## SPUpathSinglei corresponds pow = i,
## The last element, aSPUpathSingle gives aSPUpathSingle p-value.
}
\author{
Il-Youp Kwak and Wei Pan
}
\references{
Wei Pan, Il-Youp Kwak and Peng Wei (2015)
A Powerful and Pathway-Based Adaptive Test for Genetic Association With Common or Rare Variants (Submitted)
}
\seealso{
\code{\link{simPathAR1Snp}} \code{\link{aSPUpath}}
}

