% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTaSPUsSetScore.R
\name{MTaSPUsSetScore}
\alias{MTaSPUsSetScore}
\title{gene-Multitrait Sum of Powered Score (MTSPUsSetScore) tests and adaptive MTSPUsSet (MTaSPUsSet) test for multi trait - SNP set association with GWAS summary statistics. (Score version added)}
\usage{
MTaSPUsSetScore(Zs, corSNP, corPhe, pow = c(1, 2, 4, 8), pow2 = c(1, 2, 4,
  8), n.perm = 5000, Ps = FALSE)
}
\arguments{
\item{Zs}{Z-score matrix. row represent SNPs and column represent traits. It could be P-values if the Ps option is TRUE.}

\item{corSNP}{Correlation matirx of the SNPs to be tested; estimated from a
reference panel (based on the same set of the reference alleles as
used in calculating Z-scores).}

\item{corPhe}{Correlation matirx of phenotypes to be tested; Estimated from Z-scores.}

\item{pow}{SNP specific power(gamma values) used in MTSPUsSetScore test.}

\item{pow2}{GENE specific power(gamma values) used in MTSPUsSetScore test.}

\item{n.perm}{number of permutations or bootstraps.}

\item{Ps}{TRUE if input is p-value, FALSE if input is Z-scores. The default is FALSE.}
}
\value{
A vector object, MTSPUsSet test, MTScore test P values and MTaSPUsSet_Score P value.
}
\description{
It gives p-values of the MTSPUsSet tests MTScore and MTaSPUsSet_Score test with GWAS summary statistics.
}
\examples{

data(SAMD11)
attach(SAMD11)
## example analysis using aSPUM test.
(outFZ <- MTaSPUsSetScore(ZsF, corSNP=corSNPF, corPhe = corPheF,
      pow=c(1,2,4,8),  pow2 = c(1,2,4,8), n.perm=10, Ps=FALSE))


}
\references{
Il-Youp Kwak, Wei Pan (2017)
Gene- and pathway-based association tests for multiple
     traits with GWAS summary statistics, Bioinformatics. 33(1), 64-71
}
\author{
Il-Youp Kwak and Wei Pan
}
