% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processDocument.R
\name{processDocument}
\alias{processDocument}
\title{Process Document}
\usage{
processDocument(taskId = NULL, language = "English",
  profile = c("documentConversion", "documentArchiving",
  "textExtraction", "fieldLevelRecognition", "barcodeRecognition"),
  textType = c("normal", "typewriter", "matrix", "index", "ocrA", "ocrB",
  "e13b", "cmc7", "gothic"), imageSource = c("auto", "photo", "scanner"),
  correctOrientation = c("true", "false"), correctSkew = c("true",
  "false"), readBarcodes = c("false", "true"), exportFormat = c("txt",
  "txtUnstructured", "rtf", "docx", "xlsx", "pptx", "pdfSearchable",
  "pdfTextAndImages", "pdfa", "xml", "xmlForCorrectedImage", "alto"),
  description = NULL, pdfPassword = NULL, ...)
}
\arguments{
\item{taskId}{Only tasks with Submitted, Completed or NotEnoughCredits status can be processed using this function.}

\item{language}{String. Optional; default: English}

\item{profile}{String. Optional; default: \code{documentConversion}
Options: \code{documentConversion, documentArchiving, textExtraction, fieldLevelRecognition, barcodeRecognition}}

\item{textType}{String. Optional; default: \code{normal}
Options: \code{normal, typewriter, matrix, index, ocrA,ocrB, e13b,cmc7, gothic}}

\item{imageSource}{String. Optional; default: \code{auto}
Options: \code{auto, photo, scanner}}

\item{correctOrientation}{String. Optional; default: \code{true}. 
Options: \code{true} or \code{false}}

\item{correctSkew}{String. Optional; default: \code{true}.
Options: \code{true} or \code{false}}

\item{readBarcodes}{Optional; 
Options: \code{true} or \code{false}}

\item{exportFormat}{optional, default: \code{txt} 
options: \code{txt, txtUnstructured, rtf, docx, xlsx, pptx, pdfSearchable, pdfTextAndImages, pdfa, xml, xmlForCorrectedImage, alto}}

\item{description}{Optional; default: ""}

\item{pdfPassword}{Optional; default: NULL}

\item{\dots}{Additional arguments passed to \code{\link{abbyy_GET}}.}
}
\value{
\code{data.frame} with details of the task associated with the submitted Document
}
\description{
This function processes several images for the same task and results in a multi-page document. 
For instance, upload pages of the book individually via submitImage to the same task. 
And then process it via ProcessDocument to get a multi-page pdf.
}
\examples{
\dontrun{
processDocument(taskId = "task_id")
}
}
\references{
\url{http://ocrsdk.com/documentation/apireference/processDocument/}
}
