% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_target_size.R
\name{get_target_size}
\alias{get_target_size}
\title{Compute total number of loci covered in a BED file}
\usage{
get_target_size(targetbed, Mbp = TRUE)
}
\arguments{
\item{targetbed}{Genomic regions in the BED tab-delimited format.}

\item{Mbp}{Return count as Mbp. default: TRUE}
}
\value{
Mbp covered in the \code{targetbed}
}
\description{
Compute total number of loci covered in a BED file
}
\examples{
targetbed <- system.file("extdata", "regions_toy.bed", package = "abemus")
target_size <- get_target_size(targetbed=targetbed, Mbp = TRUE)
}
