% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abms.R
\name{gen_base_binomial_reg}
\alias{gen_base_binomial_reg}
\title{Logistic Regression Data generator}
\usage{
gen_base_binomial_reg(N, beta, Covariates, ni = rep(1, N))
}
\arguments{
\item{N}{The number of observations that will be generated. It must be a positive integer.}

\item{beta}{A vector of coefficients including the intercept. It can be a matrix.}

\item{Covariates}{A data.frame object with the predictors (without intercept) for which we want to test if they are relevant to the response variable. It can also be a (\eqn{n x p}) matrix.}

\item{ni}{A vector of size \eqn{n} that represent the i-th individual size (the size parameter of the binomial distribution). It can also be a (\eqn{n x 1}) matrix. For default, all individual size are fixed at 1.}
}
\value{
The function return a table with the sample of size N from the Binomial distribution indexed with the predictors indicated in the \code{Covariates} argument, the \code{ni}, the number of failures (\code{ni} - \code{y}), and the predictors for each individual .
}
\description{
It generates \code{N} observations of the Binomial distribution with parameters \code{ni} (the i-th's individual sizes) and \code{p} (the success probability), where the coefficients are indexed on \code{p} via the logistic function.
}
\examples{
N<-200    #Number of extractions
beta<-c(1, 0, 2, 0, 3, 2)    #Coefficient vector
p<-length(beta)
aux_cov<-rnorm((p-1)*N, 0,1)
Covariates<-data.frame(matrix(aux_cov, ncol=p-1, nrow=N))   #Generating the Covariates data.frame
colnames(Covariates)<-c("X1", "X2", "X3", "X4", "X5")
base<-gen_base_binomial_reg(N, beta, Covariates, ni=rep(1, N))    #Generating the data
base
}
