% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ab_scenario.R
\name{ab_time_normal}
\alias{ab_time_normal}
\title{Generate times for A/B scenarios}
\usage{
ab_time_normal(hr = 8.5, sd = 0.5, n = 1)
}
\arguments{
\item{hr}{Number representing the hour of day of departure (on average).
8.5, for example represents 08:30.}

\item{sd}{The standard deviation in hours of the distribution}

\item{n}{The number of numbers representing times to return}
}
\value{
An integer representing the time since midnight in seconds
}
\description{
Generate times for A/B scenarios
}
\examples{
time_lunch = ab_time_normal(hr = 12.5, sd = 0.25)
time_lunch
# Back to a formal time class
as.POSIXct(trunc(Sys.time(), units="days") + time_lunch)
time_morning = ab_time_normal(hr = 8.5, sd = 0.5)
as.POSIXct(trunc(Sys.time(), units="days") + time_morning)
time_afternoon = ab_time_normal(hr = 17, sd = 0.75)
as.POSIXct(trunc(Sys.time(), units="days") + time_afternoon)
}
