% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_collection.R
\name{update_collection}
\alias{update_collection}
\title{Update previous collection session}
\usage{
update_collection(data_path, end_tweets, bearer_token, ...)
}
\arguments{
\item{data_path}{string, name of an existing data_path}

\item{end_tweets}{string, new end date for data collection, it must be later then the original start date.}

\item{bearer_token}{string, bearer token}

\item{...}{arguments will be passed to \code{get_all_tweets()} function. See \code{?get_all_tweets()} for further information.}
}
\value{
a data.frame
}
\description{
This function continues previous collection session with a new end date.
For this function to work, export_query must be set to "TRUE" during the original collection.
}
\examples{
\dontrun{
bearer_token <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
update_collection(data_path = "data", "2020-01-03T00:00:00Z", bearer_token)
}
}
