% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_queryv2.R
\name{build_query}
\alias{build_query}
\title{Build tweet query}
\usage{
build_query(
  query = NULL,
  users = NULL,
  reply_to = NULL,
  retweets_of = NULL,
  exclude = NULL,
  is_retweet = NULL,
  is_reply = NULL,
  is_quote = NULL,
  is_verified = NULL,
  remove_promoted = FALSE,
  has_hashtags = NULL,
  has_cashtags = NULL,
  has_links = NULL,
  has_mentions = NULL,
  has_media = NULL,
  has_images = NULL,
  has_videos = NULL,
  has_geo = NULL,
  place = NULL,
  country = NULL,
  point_radius = NULL,
  bbox = NULL,
  lang = NULL,
  conversation_id = NULL,
  url = NULL
)
}
\arguments{
\item{query}{string or character vector, search query or queries}

\item{users}{string or character vector, user handles to collect tweets from the specified users}

\item{reply_to}{string or character vector, user handles to collect replies to the specified users}

\item{retweets_of}{string or character vector, user handles to collects retweets of tweets by the specified users}

\item{exclude}{string or character vector, tweets containing the keyword(s) will be excluded}

\item{is_retweet}{If \code{TRUE}, only retweets will be returned; if \code{FALSE}, retweets will be excluded; if \code{NULL}, both retweets and other tweet types will be returned.}

\item{is_reply}{If \code{TRUE}, only replies will be returned; if \code{FALSE}, replies will be excluded; if \code{NULL}, both replies and other tweet types will be returned.}

\item{is_quote}{If \code{TRUE}, only quote tweets will be returned; if \code{FALSE}, quote tweets will be excluded; if \code{NULL}, both quote tweets and other tweet types will be returned.}

\item{is_verified}{If \code{TRUE}, only tweets from verified accounts will be returned; if \code{FALSE}, tweets from verified accounts will be excluded; if \code{NULL}, both verified account tweets and tweets from non-verified accounts will be returned.}

\item{remove_promoted}{If \code{TRUE}, tweets created for promotion only on ads.twitter.com are removed}

\item{has_hashtags}{If \code{TRUE}, only tweets containing hashtags will be returned; if \code{FALSE}, tweets containing hashtags will be excluded; if \code{NULL}, both tweets containing hashtags and tweets without hashtags will be returned.}

\item{has_cashtags}{If \code{TRUE}, only tweets containing cashtags will be returned; if \code{FALSE}, tweets containing cashtags will be excluded; if \code{NULL}, both tweets containing cashtags and tweets without cashtags will be returned.}

\item{has_links}{If \code{TRUE}, only tweets containing links (and media) will be returned; if \code{FALSE}, tweets containing links (and media) will be excluded; if \code{NULL}, both tweets containing links (and media) and tweets without links (and media) will be returned.}

\item{has_mentions}{If \code{TRUE}, only tweets containing mentions will be returned; if \code{FALSE}, tweets containing mentions will be excluded; if \code{NULL}, both tweets containing mentions and tweets without mentions will be returned.}

\item{has_media}{If \code{TRUE}, only tweets containing media such as a photo, GIF, or video (as determined by Twitter) will be returned will be returned; if \code{FALSE}, tweets containing media will be excluded; if \code{NULL}, both tweets containing media and tweets without media will be returned.}

\item{has_images}{If \code{TRUE}, only tweets containing (recognized URLs to) images will be returned will be returned will be returned; if \code{FALSE}, tweets containing images will be excluded; if \code{NULL}, both tweets containing images and tweets without images will be returned.}

\item{has_videos}{If \code{TRUE},  only tweets containing contain videos (recognized as native videos uploaded directly to Twitter) will be returned will be returned; if \code{FALSE}, tweets containing videos will be excluded; if \code{NULL}, both tweets containing videos and tweets without videos will be returned.}

\item{has_geo}{If \code{TRUE}, only tweets containing geo information (Tweet-specific geolocation data provided by the Twitter user) will be returned; if \code{FALSE}, tweets containing geo information will be excluded; if \code{NULL}, both tweets containing geo information and tweets without geo information will be returned.}

\item{place}{string, name of place e.g. "London"}

\item{country}{string, name of country as ISO alpha-2 code e.g. "GB"}

\item{point_radius}{numeric, a vector of two point coordinates latitude, longitude, and point radius distance (in miles)}

\item{bbox}{numeric, a vector of four bounding box coordinates from west longitude to north latitude}

\item{lang}{string, a single BCP 47 language identifier e.g. "fr"}

\item{conversation_id}{string, return tweets that share the specified conversation ID}

\item{url}{string, url}
}
\value{
a query string
}
\description{
Build tweet query according to targeted parameters.
}
\details{
This function is already called within the main
\code{\link{get_all_tweets}} function.

It may also be called separately and the output saved as
a character object query string to be input as query parameter to \code{\link{get_all_tweets}}.
}
\examples{
\dontrun{
query <- build_query(query = "happy", is_retweet = FALSE,
                     country = "US",
                     place = "seattle",
                     point_radius = c(-122.33795253639994, 47.60900846404393, 25),
                     lang = "en")
                     
query <- build_query(query = "twitter",
                     point_radius = c(-122.33795253639994, 47.60900846404393, 25),
                     lang = "en")
                     
}

}
