% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_eaf_export.R
\name{eaf_export}
\alias{eaf_export}
\title{Exports a transcript object to a single 'Elan' '*.eaf' file}
\usage{
eaf_export(t, outputPath, createMediaLinks = FALSE)
}
\arguments{
\item{t}{Transcript object; transcript to be exported.}

\item{outputPath}{Character string; path where EAF file will be saved.}

\item{createMediaLinks}{Logical; if \code{TRUE} media links will be created.}
}
\description{
Exports a transcript object to a single 'Elan' '*.eaf' file
}
\examples{
library(act)

# Get the transcript you want to export
t <- examplecorpus@transcripts[[1]]

#Create temporary file path
path <- tempfile(pattern = t@name, tmpdir = tempdir(), fileext = ".eaf")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer
\dontrun{
path <- file.path("PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
                   paste(t@name, ".eaf", sep=""))
}

# Export WITHOUT media links
act::eaf_export(t=t, outputPath=path)

# Export WITH media links
act::eaf_export(t=t, outputPath=path, createMediaLinks=TRUE)
}
\seealso{
\link{transcripts_export}, \link{textgrid_export}, , \link{textgrid_import}
}
