% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_textgrid_export.R
\name{textgrid_export}
\alias{textgrid_export}
\title{Export a single transcript object to a 'Praat' *.TextGrid' file.}
\usage{
textgrid_export(t, outputPath)
}
\arguments{
\item{t}{Transcript object; transcript to be saved.}

\item{outputPath}{Character string; path where TextGrid will be saved.}
}
\description{
Export a single transcript object to a 'Praat' *.TextGrid' file.
}
\examples{
library(act)

# Set destination folder
outputFolder <- tempdir()

# It makes more sense, however, to you define a folder
# that is easier to access on your computer
\dontrun{
outputFolder <- "PATH_TO_AN_EMPTY_FOLDER_ON_YOUR_COMPUTER"
}

# Exports all transcript objects in Praat TextGrid format
act::transcripts_export(x=examplecorpus,
                              outputFolder=outputFolder,
                              formats="textgrid")

# Exports all transcript objects in ELAN eaf format.
# By default WITHOUT creating media links
act::transcripts_export(x=examplecorpus,
                                 outputFolder=outputFolder,
                                 formats="eaf")

# Same same, but now WITH media links.
# Only Media links are only exported that are in
# the '@path.media' attribute in the transcript object(s))
act::transcripts_export(x=examplecorpus,
                                 outputFolder=outputFolder,
                                 formats="eaf",
                                 createMediaLinks=TRUE)

# Exports in 'eaf' and 'textgrid' format
act::transcripts_export(x=examplecorpus,
                                 outputFolder=outputFolder,
                                 formats=c("eaf", "textgrid"),
                                 createMediaLinks=TRUE)

# In case you do not want to export all tiers of the transcripts
# you can use the following options:
# * \code{act.export.filter.tiers.exclude}
# * \code{act.export.filter.tiers.include}
# Please see the section about setting options for act.
}
\seealso{
\link{transcripts_export}, \link{eaf_export}, \link{textgrid_import}
}
