% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_transcriptNames_make.R
\name{helper_transcriptNames_make}
\alias{helper_transcriptNames_make}
\title{Helper: Makes valid names for all transcripts in a corpus}
\usage{
helper_transcriptNames_make(
  transcriptNames,
  searchPatterns = character(),
  searchReplacements = character(),
  toUpperCase = FALSE,
  toLowerCase = FALSE,
  trim = FALSE,
  defaultForEmptyNames = "no_name"
)
}
\arguments{
\item{transcriptNames}{Vector of character strings; Names of the transcripts to validate.}

\item{searchPatterns}{Vector of character strings; Search pattern as regular expression. Leave empty for no search-replace in the names.}

\item{searchReplacements}{Vector of character strings; Replacements for search. Leave empty for no search-replace in the names.}

\item{toUpperCase}{Logical; Convert transcript names all to upper case.}

\item{toLowerCase}{Logical; Convert transcript names all to lower case.}

\item{trim}{Logical; Remove leading and trailing spaces in names.}

\item{defaultForEmptyNames}{Character string; Default value for empty transcript names (e.g., resulting from search-replace operations)}
}
\value{
List
}
\description{
Makes valid names for all transcript objects in a corpus object based on the names passed in 'transcriptNames' parameter.
In particular, the functions also corrects names, which have to be non-empty and unique.
The following options are performed in the mentioned order.
}
\examples{
library(act)

# make some names with an empty value "" and a duplivate "d"
transcriptNames <- c("a", "b", "", "d", "d")
act::helper_transcriptNames_make(transcriptNames)

}
