% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{transitionLayer}
\alias{transitionLayer}
\title{Calculate Transition Layer}
\usage{
transitionLayer(x, directions = c(16, 8, 4))
}
\arguments{
\item{x}{A water raster; for example the output of \code{\link{loadShape}}}

\item{directions}{The number of directions considered for every movement situation during cost
calculation. See the vignettes for more details.}
}
\value{
A TransitionLayer object.
}
\description{
Using a previously imported shape file that has been converted to a raster (see \code{\link{loadShape}}),
Prepares a TransitionLayer object to be used in distance
estimations (see \code{\link{distancesMatrix}}). Adapted from Grant Adams' script "distance to closest mpa".
}
\details{
It is highly recommended to read the vignette regarding distances matrix before running this function.
You can find it by running \code{vignette('a-2_distances_matrix', 'actel')} or \code{browseVignettes('actel')}
}
\examples{
\donttest{
# check if R can run the distance functions
aux <- c(
  length(suppressWarnings(packageDescription("raster"))),
  length(suppressWarnings(packageDescription("gdistance"))),
  length(suppressWarnings(packageDescription("sp"))),
  length(suppressWarnings(packageDescription("tools"))),
  length(suppressWarnings(packageDescription("rgdal"))))
missing.packages <- sapply(aux, function(x) x == 1)

if (any(missing.packages)) {
  message("Sorry, this function requires packages '",
    paste(c("raster", "gdistance", "sp", "tools", "rgdal")[missing.packages], collapse = "', '"),
    "' to operate. Please install ", ifelse(sum(missing.packages) > 1, "them", "it"),
    " before proceeding.")
} else {
  if (suppressWarnings(require("rgdal"))) {
    # Fetch actel's example shapefile location
    aux <- system.file(package = "actel")[1]

    # import the shape file
    x <- loadShape(path = aux, shape = "example_shapefile.shp", size = 20)

    # Build the transition layer
    t.layer <- transitionLayer(x)

    # inspect the output
    t.layer

  } else {
    message("Sorry, it appears that rgdal is not being able to load.")
  }
}
rm(aux, missing.packages)
}
}
