% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_fada_robust.R
\name{do_fada_robust}
\alias{do_fada_robust}
\title{Run the whole archetypoid analysis with the functional robust Frobenius norm}
\usage{
do_fada_robust(subset, numArchoid, numRep, huge, prob, compare = FALSE, PM,
              vect_tol = c(0.95, 0.9, 0.85), alpha = 0.05, 
              outl_degree = c("outl_strong", "outl_semi_strong", "outl_moderate"),
              method = "adjbox")
}
\arguments{
\item{subset}{Data to obtain archetypes. In fadalara this is a subset of the 
entire data frame.}

\item{numArchoid}{Number of archetypes/archetypoids.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} times.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{prob}{Probability with values in [0,1].}

\item{compare}{Boolean argument to compute the non-robust residual sum of squares 
to compare these results with the ones provided by \code{\link{do_fada}}.}

\item{PM}{Penalty matrix obtained with \code{\link[fda]{eval.penalty}}.}

\item{vect_tol}{Vector the tolerance values. Default c(0.95, 0.9, 0.85).
Needed if \code{method='toler'}.}

\item{alpha}{Significance level. Default 0.05. Needed if \code{method='toler'}.}

\item{outl_degree}{Type of outlier to identify the degree of outlierness.
Default c("outl_strong", "outl_semi_strong", "outl_moderate").
Needed if \code{method='toler'}.}

\item{method}{Method to compute the outliers. Options allowed are 'adjbox' for
using adjusted boxplots for skewed distributions, and 'toler' for using
tolerance intervals.}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item rss_non_rob: If \code{compare=TRUE}, this is the residual sum of squares using
the non-robust Frobenius norm. Otherwise, NULL.
\item resid: Vector of residuals.
\item outliers: Outliers.
}
}
\description{
This function executes the entire procedure involved in the functional archetypoid 
analysis. Firstly, the initial vector of archetypoids is obtained using the 
functional archetypal algorithm and finally, the optimal vector of archetypoids is 
returned.
}
\examples{
\dontrun{
library(fda)
?growth
str(growth)
hgtm <- t(growth$hgtm)

# Create basis:
basis_fd <- create.bspline.basis(c(1,ncol(hgtm)), 10)
PM <- eval.penalty(basis_fd)
# Make fd object:
temp_points <- 1:ncol(hgtm)
temp_fd <- Data2fd(argvals = temp_points, y = growth$hgtm, basisobj = basis_fd)
data_archs <- t(temp_fd$coefs)

suppressWarnings(RNGversion("3.5.0"))
set.seed(2018)
res_fada_rob <- do_fada_robust(subset = data_archs, numArchoid = 3, numRep = 5, huge = 200,
                               prob = 0.75, compare = FALSE, PM = PM, method = "adjbox")
str(res_fada_rob)  

suppressWarnings(RNGversion("3.5.0"))
set.seed(2018)
res_fada_rob1 <- do_fada_robust(subset = data_archs, numArchoid = 3, numRep = 5, huge = 200,
                                prob = 0.75, compare = FALSE, PM = PM, 
                                vect_tol = c(0.95, 0.9, 0.85), alpha = 0.05, 
                                outl_degree = c("outl_strong", "outl_semi_strong", "outl_moderate"),
                                method = "toler")
str(res_fada_rob1) 
}
                                  
}
\references{
Moliner, J. and Epifanio, I., Robust multivariate and functional archetypal analysis 
with application to financial time series analysis, 2019. 
\emph{Physica A: Statistical Mechanics and its Applications} \bold{519}, 195-208. 
\url{https://doi.org/10.1016/j.physa.2018.12.036}
}
\seealso{
\code{\link{stepArchetypesRawData_funct_robust}}, 
\code{\link{archetypoids_funct_robust}}
}
\author{
Guillermo Vinue, Irene Epifanio
}
