

rm(list=ls())
set.seed( 2011 )

library(adapr)


source.file <-"graph_cardata.R"
project.id <- "adaprTest"
source_info <- create_source_file_dir(source.description="make some histograms")

Library("ggplot2","cran")


# Program body here

cardata.filtered <- loadFlex("read_data.R/cardata.RData")


disp.histogram <- ggplot(cardata.filtered,aes(x=disp))+geom_histogram(binwidth=100)+theme_bw()+facet_grid(.~cyl)+ggtitle("Displacement vs. # of Cylinders")

Graph("histograms.pdf","dispacement and mpg by cylinder")

print(disp.histogram )

print(ggplot(cardata.filtered,aes(x=mpg))+geom_histogram(binwidth=7.5)+theme_bw()+facet_grid(.~cyl)+ggtitle("Miles per gallon vs. # of Cylinders"))

graphics.off()

Write(disp.histogram,"disp_histogram.RData","more cyl more disp")

# End Program Body


dependency.out <- finalize_dependency()
