% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.trial_results}
\title{Summary of simulated trial results}
\usage{
\method{summary}{trial_results}(
  object,
  select_strategy = "control if available",
  select_last_arm = FALSE,
  select_preferences = NULL,
  te_comp = NULL,
  raw_ests = FALSE,
  restrict = NULL,
  ...
)
}
\arguments{
\item{object}{\code{trial_results} object, output from the \link{run_trials} function.}

\item{select_strategy}{single character string. For trials not stopped
due to superiority (or with only 1 arm remaining, if \code{select_last_arm} is
set to \code{TRUE} in trial designs with a common \code{control} arm; see below),
this parameter specifies which arm will be considered selected when
calculating trial design performance metrics (described below;
this corresponds to the consequence of an inconclusive trial, i.e., which
arm would then be used in practice).\cr
The following options are available and must be written exactly as below
(case sensitive, cannot be abbreviated):
\itemize{
\item \code{"control if available"} (default): selects the \strong{first}
\code{control} arm for trials with a common control arm \emph{\strong{if}} this arm
is active at end-of-trial, otherwise no arm will be selected. For
trial designs without a common \code{control}, no arm will be selected.
\item \code{"none"}: selects no arm in trials not ending with superiority.
\item \code{"control"}: similar to \code{"control if available"}, but will throw
an error for trial designs without a common \code{control} arm.
\item \code{"final control"}: selects the \strong{final} \code{control} arm regardless
of whether the trial was stopped for practical equivalence, futility,
or at the maximum sample size; this strategy can only be specified
for trial designs with a common \code{control} arm.
\item \code{"control or best"}: selects the \strong{first} \code{control} arm if still
active at end-of-trial, otherwise selects the best remaining arm
(defined as the remaining arm with the highest probability of being
the best in the final analysis). Only works for trial designs with a
common \code{control} arm.
\item \code{"best"}: selects the best remaining arm (as described under
\code{"control or best"}).
\item \code{"list or best"}: selects the first remaining arm from a specified
list (specified using \code{select_preferences}, technically a character
vector). If none of these arms are are active at end-of-trial, the best
remaining arm will be selected (as described above).
\item \code{"list"}: as specified above, but if no arms on the provided list
remain active at end-of-trial, no arm is selected.
}}

\item{select_last_arm}{single logical, defaults to \code{FALSE}. If \code{TRUE}, the
only remaining active arm (the last \code{control}) will be selected in trials
with a common \code{control} arm ending with \code{equivalence} or \code{futility}, before
considering the options specified in \code{select_strategy}. Must be \code{FALSE} for
trial designs without a common \code{control} arm.}

\item{select_preferences}{character vector specifying a number of arms used
for selection if one of the \code{"list or best"} or \code{"list"} options are
specified for \code{select_strategy}. Can only contain valid \code{arms}
available in the trial.}

\item{te_comp}{character string, treatment-effect comparator. Can be either
\code{NULL} (the default) in which case the \strong{first} \code{control} arm is used for
trial designs with a common control arm, or a single trial \code{arm}. Will be
used when calculating \code{sq_err_te} (the squared error of the treatment
effect comparing the selected arm to the comparator arm, as described
below).}

\item{raw_ests}{single logical. If \code{FALSE} (default), the
posterior estimates (\code{post_ests}, see \link{setup_trial} and
\link{run_trial}) will be used to calculate \code{sq_err} (the squared error of the
estimated compared to the specified effect in the selected arm) and
\code{sq_err_te} (the squared error of the treatment effect comparing the
selected arm to the comparator arm, as described for \code{te_comp} and below).
If \code{TRUE}, the raw estimates (\code{raw_ests}, see \link{setup_trial} and
\link{run_trial}) will be used instead of the posterior estimates.}

\item{restrict}{single character string or \code{NULL}. If \code{NULL} (default),
results are summarised for all simulations; if \verb{"superior}, results are
summarised for simulations ending with superiority only; if \code{"selected"},
results are summarised for simulations ending with a selected arm
(according to the specified arm selection strategy for simulations not
ending with superiority). Some summary measures (e.g., \code{prob_conclusive})
can only be calculated across all simulations and several are calculated
regardless of \code{restrict} settings, but have substantially different
interpretations if restricted.}

\item{...}{additional arguments, not used.}
}
\value{
A \code{"trial_results_summary"} object containing the following:
\itemize{
\item \code{n_rep}: the number of simulations.
\item \code{n_summarised}: the number of simulations summarised.
\item \code{highest_is_best}: as specified in \link{setup_trial}.
\item \code{elapsed_time}: the total simulation time.
\item \code{size_mean}, \code{size_sd}, \code{size_median}, \code{size_p25}, \code{size_p75}: the
mean, standard deviation, median as well as 25- and 75-percentiles of the
sample sizes of the summarised trial simulations.
\item \code{sum_ys_mean}, \code{sum_ys_sd}, \code{sum_ys_median}, \code{sum_ys_p25},
\code{sum_ys_p75}: the mean, standard deviation, median as well as 25- and
75-percentiles of the total \code{sum_ys} (e.g., the total number of events in
trials with a binary outcome, or the sums of continuous values for all
patients across all arms in trials with a continuous outcome) across all
arms in the summarised trial simulations.
\item \code{ratio_ys_mean}, \code{ratio_ys_sd}, \code{ratio_ys_median}, \code{ratio_ys_p25},
\code{ratio_ys_p75}: the mean, standard deviation, median as well as 25- and
75-percentiles of the final \code{ratio_ys} (\code{sum_ys/final_n}) across all arms
in the summarised trial simulations.
\item \code{prob_conclusive}: the proportion of conclusive trial simulations
(simulations not stopped at the maximum sample size without a
superiority, equivalence or futility decision).
\item \code{prob_superior}, \code{prob_equivalence}, \code{prob_futility}, \code{prob_max}: the
proportion (0-1) of trial simulations stopped for superiority,
equivalence, futility or inconclusive at the maximum allowed sample size,
respectively.
\item \verb{prob_select_*}: the selection probabilities for each arm and for no
selection, according to the specified selection strategy. Contains one
element per \code{arm}, named as \verb{prob_select_arm_<arm name>} and
\code{prob_select_none} for the probability of selecting no arm.
\item \code{rmse}, \code{rmse_te}: the root mean squared error of the estimates for
the selected arm and for the treatment effect, as described further in
\link{extract_results}.
\item \code{idp}: the ideal design percentage (IDP; 0-100\%), see \strong{Details}.
\item \code{select_strategy}, \code{select_last_arm}, \code{select_preferences},
\code{te_comp}, \code{raw_ests},\code{restrict}: as specified above.
\item \code{control}: the control arm specified by \link{setup_trial},
\link{setup_trial_binom} or \link{setup_trial_norm}; \code{NULL} if no control.
\item \code{equivalence_assessed}, \code{futility_assessed}: single logicals,
specifies whether the trial design specification includes assessments of
equivalence and/or futility.
\item \code{base_seed}: as specified in \link{run_trials}.
\item \code{cri_width}, \code{n_draws}, \code{robust}, \code{description}, \code{add_info}: as
specified in \link{setup_trial}, \link{setup_trial_binom} or \link{setup_trial_norm}.
}
}
\description{
Summarises simulation results from the \link{run_trials} function. Uses
\link{extract_results}, which may be used directly to extract key trial results
without summarising.
}
\details{
The ideal design percentage (IDP) returned (described below) is based on
\emph{Viele et al, 2020} \doi{10.1177/1740774519877836} and
has been adapted to work for trials with both desirable/undesirable outcomes
and non-binary outcomes. Briefly, the expected outcome is calculated as the
sum of the true outcomes in each arm multiplied by the corresponding
selection probabilities (ignoring simulations with no selected arm). The IDP
is then calculated as:
\itemize{
\item For desirable outcomes:\cr
\verb{100 * (expected outcome - lowest true outcome) / (highest true outcome - lowest true outcome)}
\item For undesirable outcomes:\cr
\verb{100 - IDP calculated for desirable outcomes}
}
}
\examples{
# Setup a trial specification
binom_trial <- setup_trial_binom(arms = c("A", "B", "C", "D"),
                                 control = "A",
                                 true_ys = c(0.20, 0.18, 0.22, 0.24),
                                 data_looks = 1:20 * 100)

# Run 10 simulations with a specified random base seed
res <- run_trials(binom_trial, n_rep = 10, base_seed = 12345)

# Summarise simulations - select the control arm if available in trials not
# ending with a superiority decision
res_sum <- summary(res, select_strategy = "control")

# Print summary
print(res_sum, digits = 1)

}
