% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{pareto_chart}
\alias{pareto_chart}
\title{Pareto's chart}
\usage{
pareto_chart(obj, ...)
}
\arguments{
\item{obj}{an object}

\item{...}{further parameters to specialized functions}
}
\value{
a Pareto chart of the effects of the model
}
\description{
This is a generic function for Pareto's chart.
}
\examples{
# For a data frame:
library(tibble)
set.seed(1)
tibble(
  val=rnorm(10, sd=5),
  cat=LETTERS[1:length(val)]
  ) \%>\%
  pareto_chart(labels=cat, values=val)

# For a linear model:
pareto_chart(lm(Y~A*B*C*D, data=filtration))
}
\seealso{
\code{\link[=pareto_chart.data.frame]{pareto_chart.data.frame()}} \code{\link[=pareto_chart.lm]{pareto_chart.lm()}}
}
