% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/driver_void.R
\name{adbc_load_flags}
\alias{adbc_load_flags}
\title{Driver search/load options}
\usage{
adbc_load_flags(
  search_env = TRUE,
  search_user = TRUE,
  search_system = TRUE,
  allow_relative_paths = TRUE
)
}
\arguments{
\item{search_env}{Search for manifest files in the directories specified by
the ADBC_CONFIG_PATH environment variable.}

\item{search_user}{Search for manifest files in the designated directory
for user ADBC driver installs.}

\item{search_system}{Search for manifest files in the designtaed directory
for system ADBC driver installs.}

\item{allow_relative_paths}{Allow shared objects to be specified relative to
the current working directory.}
}
\value{
An integer flag value for use in \code{adbc_driver()}
}
\description{
Options that indicate where to look for driver manifests. Manifests
(.toml files) can be installed at the system level, the user level,
and/or location(s) specified by the ADBC_CONFIG_PATH environment variable.
See the ADBC documentation for details regarding the locations of the
user and system paths on various platforms.
}
