\name{scaleline}
\alias{scaleline}
\alias{scaleline.scaledTrellis}

\title{
Extract scaleline list from \code{scaledTrellis} object
}
\description{
Extracts the scaleline list from an object inheriting from class  \code{scaledTrellis}. This is useful if the user wants to create their own legend rather than using that generated by \code{addScales}.
}
\usage{
scaleline(obj, \dots)
\method{scaleline}{scaledTrellis}(obj, \dots)
}

\arguments{
  \item{obj}{
\code{scaledTrellis} object
}
  \item{\dots}{
Possible further arguments for future methods. Ignored at present.
   }
}
\details{
Extracts the \code{scaleline} list from a \code{scaledTrellis} object. Note that the actual calculated values are returned, not the rounded/formatted values that would be shown in the legend.
}
\value{
A list with components:
\describe{
  \item{h}{numeric: distance between horizontal scalelines and midline}
  \item{v}{numeric: distance between vertical scalelines and midline}
  }
}

\author{
Bert Gunter \email{bgunter.4567@gmail.com}
}


\examples{
set.seed(8763)
simp <- xyplot(rnorm(10) ~ runif(10))
## Plot it
simp

## Add horizontal and vertical scale lines
ad <-addScales(simp,
 scaleline = TRUE,,
 ndig.midline = 1  ## only 1 digit will be shown
)
## Plot it
ad

## But here are the actual values
## (shown to default number of digits given
## by "digits" argument of print.default)
scaleline(ad)

## cleanup
rm(simp, ad)
}
\seealso{
   \code{\link{addScales}}
}

\keyword{methods}
\keyword{ hplot }
\keyword{ aplot }
