% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{glm.cox}
\alias{glm.cox}
\title{Creates a Cox GLM family object.}
\usage{
glm.cox(start, stop, status, weights = NULL, tie_method = "efron")
}
\arguments{
\item{start}{Start time vector.}

\item{stop}{Stop time vector.}

\item{status}{Status vector.}

\item{weights}{Observation weights.}

\item{tie_method}{The tie-breaking method.}
}
\value{
Cox GLM object.
}
\description{
Creates a Cox GLM family object.
}
\examples{
n <- 100
start <- sample.int(20, size=n, replace=TRUE)
stop <- start + 1 + sample.int(5, size=n, replace=TRUE)
status <- rbinom(n, 1, 0.5)
obj <- glm.cox(start, stop, status)
}
