% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{matrix.kronecker_eye}
\alias{matrix.kronecker_eye}
\title{Creates a Kronecker product with identity matrix.}
\usage{
matrix.kronecker_eye(mat, K, n_threads = 1)
}
\arguments{
\item{mat}{The matrix to view as a Kronecker product.}

\item{K}{Dimension of the identity matrix.}

\item{n_threads}{Number of threads.}
}
\value{
Kronecker product with identity matrix.
}
\description{
Creates a Kronecker product with identity matrix.
}
\examples{
n <- 100
p <- 20
K <- 2
mat <- matrix(rnorm(n * p), n, p)
out <- matrix.kronecker_eye(mat, K)
mat <- matrix.dense(mat)
out <- matrix.kronecker_eye(mat, K)
}
