% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{print.cv.grpnet}
\alias{print.cv.grpnet}
\title{print a cross-validated grpnet object}
\usage{
\method{print}{cv.grpnet}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{fitted 'cv.grpnet' object}

\item{digits}{significant digits in printout}

\item{\dots}{additional print arguments}
}
\description{
Print a summary of the results of cross-validation for a grpnet model.
}
\examples{

x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit1 = cv.grpnet(x, glm.gaussian(y))
print(fit1)
}
\references{
Yang, James and Hastie, Trevor. (2024) A Fast and Scalable Pathwise-Solver for Group Lasso
and Elastic Net Penalized Regression via Block-Coordinate Descent. arXiv \doi{10.48550/arXiv.2405.08631}.
}
\seealso{
\code{grpnet}, \code{predict} and \code{coef} methods.
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan\cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{group}
\keyword{lasso}
\keyword{models}
\keyword{regression}
