% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_disposition_reason.R
\name{derive_vars_disposition_reason}
\alias{derive_vars_disposition_reason}
\title{Derive a Disposition Reason at a Specific Timepoint}
\usage{
derive_vars_disposition_reason(
  dataset,
  dataset_ds,
  new_var,
  reason_var,
  new_var_spe = NULL,
  reason_var_spe = NULL,
  format_new_vars = format_reason_default,
  filter_ds,
  subject_keys = get_admiral_option("subject_keys")
)
}
\arguments{
\item{dataset}{Input dataset}

\item{dataset_ds}{Dataset containing the disposition information (e.g. \code{ds})

The dataset must contain:
\itemize{
\item \code{STUDYID}, \code{USUBJID},
\item The variable(s) specified in the \code{reason_var} (and \code{reason_var_spe}, if required)
\item The variables used in \code{filter_ds}.
}}

\item{new_var}{Name of the disposition reason variable

A variable name is expected (e.g. \code{DCSREAS}).}

\item{reason_var}{The variable used to derive the disposition reason

A variable name is expected (e.g. \code{DSDECOD}).}

\item{new_var_spe}{Name of the disposition reason detail variable

A variable name is expected (e.g. \code{DCSREASP}).
If \code{new_var_spe} is specified, it is expected that \code{reason_var_spe} is also specified,
otherwise an error is issued.

Default: NULL}

\item{reason_var_spe}{The variable used to derive the disposition reason detail

A variable name is expected (e.g. \code{DSTERM}).
If \code{new_var_spe} is specified, it is expected that \code{reason_var_spe} is also specified,
otherwise an error is issued.

Default: NULL}

\item{format_new_vars}{The function used to derive the reason(s)

This function is used to derive the disposition reason(s) and must follow the below conventions
\itemize{
\item If only the main reason for discontinuation needs to be derived (i.e. \code{new_var_spe} is NULL),
the function must have at least one character vector argument, e.g.
\verb{format_reason <- function(reason)}
and \code{new_var} will be derived as \code{new_var = format_reason(reason_var)}.
Typically, the content of the function would return \code{reason_var} or \code{NA} depending on the
value (e.g. \code{if_else ( reason != "COMPLETED" & !is.na(reason), reason, NA_character_)}).
\code{DCSREAS = format_reason(DSDECOD)} returns \code{DCSREAS = DSDECOD}
when \code{DSDECOD} is not \code{'COMPLETED'} nor \code{NA}, \code{NA} otherwise.
\item If both the main reason and the details needs to be derived (\code{new_var_spe} is specified)
the function must have two character vectors argument, e.g.
\verb{format_reason2 <- function(reason, reason_spe)} and
\code{new_var} will be derived as \code{new_var = format_reason(reason_var)},
\code{new_var_spe} will be derived as \code{new_var_spe = format_reason(reason_var, reason_var_spe)}.
Typically, the content of the function would return \code{reason_var_spe} or \code{NA} depending on the
\code{reason_var} value (e.g. \code{if_else ( reason == "OTHER", reason_spe, NA_character_)}).
\code{DCSREASP = format_reason(DSDECOD, DSTERM)} returns \code{DCSREASP = DSTERM} when
\code{DSDECOD} is equal to \code{'OTHER'}.
}

Default: \code{format_reason_default}, see \code{\link[=format_reason_default]{format_reason_default()}} for details.}

\item{filter_ds}{Filter condition for the disposition data.

Filter used to select the relevant disposition data.
It is expected that the filter restricts \code{dataset_ds} such that there is at most
one observation per patient. An error is issued otherwise.

Permitted Values: logical expression.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of expressions where the expressions are symbols as returned by
\code{exprs()} is expected.}
}
\value{
the input dataset with the disposition reason(s) (\code{new_var} and
if required \code{new_var_spe}) added.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}. Please use \code{derive_vars_merged()} and
specify the \code{filter_add} argument to derive the respective variables.

Derive a disposition reason from the the relevant records in the disposition domain.
}
\details{
This functions returns the main reason for discontinuation (e.g. \code{DCSREAS} or \code{DCTREAS}).
The reason for discontinuation is derived based on \code{reason_var} (e.g. \code{DSDECOD}) and
\code{format_new_vars}.
If \code{new_var_spe} is not NULL, then the function will also return the details associated
with the reason for discontinuation (e.g. \code{DCSREASP}).
The details associated with the reason for discontinuation are derived based on
\code{reason_var_spe} (e.g. \code{DSTERM}), \code{reason_var} and \code{format_new_vars}.
}
\seealso{
\code{\link[=format_reason_default]{format_reason_default()}}

Other deprecated: 
\code{\link{derive_derived_param}()},
\code{\link{derive_param_first_event}()},
\code{\link{derive_var_agegr_fda}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_merged_dtm}()},
\code{\link{derive_vars_merged_dt}()},
\code{\link{filter_confirmation}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()},
\code{\link{vars}()}
}
\concept{deprecated}
\keyword{deprecated}
