% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_extreme_records.R
\name{derive_extreme_records}
\alias{derive_extreme_records}
\title{Add the First or Last Observation for Each By Group as New Records}
\usage{
derive_extreme_records(
  dataset,
  by_vars = NULL,
  order,
  mode,
  check_type = "warning",
  filter = NULL,
  set_values_to
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{order} and the \code{by_vars} parameter are
expected.}

\item{by_vars}{Grouping variables

\emph{Default}: \code{NULL}

\emph{Permitted Values:} list of variables created by \code{exprs()}}

\item{order}{Sort order

Within each by group the observations are ordered by the specified order.

\emph{Permitted Values:} list of variables or \verb{desc(<variable>)} function calls
created by \code{exprs()}, e.g., \code{exprs(ADT, desc(AVAL))}}

\item{mode}{Selection mode (first or last)

If \code{"first"} is specified, the first observation of each by group is added
to the input dataset. If \code{"last"} is specified, the last observation of
each by group is added to the input dataset.

\emph{Permitted Values:} \code{"first"}, \code{"last"}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, the specified message is issued
if the observations of the input dataset are not unique with respect to the
by variables and the order.

\emph{Default:} \code{"warning"}

\emph{Permitted Values:} \code{"none"}, \code{"warning"}, \code{"error"}}

\item{filter}{Filter for observations to consider

Only observations fulfilling the specified condition are taken into account
for selecting the first or last observation. If the parameter is not
specified, all observations are considered.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: a condition}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations.

A list of variable name-value pairs is expected.
\itemize{
\item LHS refers to a variable.
\item RHS refers to the values to set to the variable. This can be a string, a
symbol, a numeric value or \code{NA}, e.g., \code{exprs(PARAMCD = "TDOSE", PARCAT1 =   "OVERALL")}. More general expression are not allowed.
}}
}
\value{
The input dataset with the first or last observation of each by group
added as new observations.
}
\description{
Add the first or last observation for each by group as new observations. It
can be used for example for adding the maximum or minimum value as a separate
visit. All variables of the selected observation are kept. This distinguish
\code{derive_extreme_records()} from \code{derive_summary_records()}, where only the by
variables are populated for the new records.
}
\details{
\enumerate{
\item The input dataset is restricted as specified by the \code{filter} parameter.
\item For each group (with respect to the variables specified for the
\code{by_vars} parameter) the first or last observation (with respect to the
order specified for the \code{order} parameter and the mode specified for the
\code{mode} parameter) is selected.
\item The variables specified by the \code{set_values_to} parameter are added to
the selected observations.
\item The observations are added to input dataset.
}
}
\examples{
library(tibble)

adlb <- tribble(
  ~USUBJID, ~AVISITN, ~AVAL, ~LBSEQ,
  "1",      1,          113,      1,
  "1",      2,          113,      2,
  "1",      3,          117,      3,
  "2",      1,          101,      1,
  "2",      2,          101,      2,
  "2",      3,           95,      3
)

# Add a new record for each USUBJID storing the minimum value (first AVAL).
# If multiple records meet the minimum criterion, take the first value by
# AVISITN. Set AVISITN = 97 and DTYPE = MINIMUM for these new records.
derive_extreme_records(
  adlb,
  by_vars = exprs(USUBJID),
  order = exprs(AVAL, AVISITN),
  mode = "first",
  filter = !is.na(AVAL),
  set_values_to = exprs(
    AVISITN = 97,
    DTYPE = "MINIMUM"
  )
)

# Add a new record for each USUBJID storing the maximum value (last AVAL).
# If multiple records meet the maximum criterion, take the first value by
# AVISITN. Set AVISITN = 98 and DTYPE = MAXIMUM for these new records.
derive_extreme_records(
  adlb,
  by_vars = exprs(USUBJID),
  order = exprs(desc(AVAL), AVISITN),
  mode = "first",
  filter = !is.na(AVAL),
  set_values_to = exprs(
    AVISITN = 98,
    DTYPE = "MAXIMUM"
  )
)

# Add a new record for each USUBJID storing for the last value.
# Set AVISITN = 99 and DTYPE = LOV for these new records.
derive_extreme_records(
  adlb,
  by_vars = exprs(USUBJID),
  order = exprs(AVISITN),
  mode = "last",
  set_values_to = exprs(
    AVISITN = 99,
    DTYPE = "LOV"
  )
)
}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_extreme_event}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
