% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_atoxgr.R
\name{derive_var_atoxgr_dir}
\alias{derive_var_atoxgr_dir}
\title{Derive Lab Toxicity Grade 0 - 4}
\usage{
derive_var_atoxgr_dir(
  dataset,
  new_var,
  tox_description_var,
  meta_criteria,
  criteria_direction,
  get_unit_expr,
  signif_dig = 15
)
}
\arguments{
\item{dataset}{Input data set

The columns specified by \code{tox_description_var} parameter is expected.}

\item{new_var}{Name of the character grade variable to create, for example, \code{ATOXGRH}
or \code{ATOXGRL}.}

\item{tox_description_var}{Variable containing the description of the grading
criteria. For example: "Anemia" or "INR Increased".}

\item{meta_criteria}{Metadata data set holding the criteria (normally a case statement)

Permitted Values: \code{atoxgr_criteria_ctcv4}, \code{atoxgr_criteria_ctcv5}, \code{atoxgr_criteria_daids}
\itemize{
\item \code{atoxgr_criteria_ctcv4} implements \href{https://ctep.cancer.gov/protocoldevelopment/electronic_applications/ctc.htm}{Common Terminology Criteria for Adverse Events (CTCAE) v4.0}
\item \code{atoxgr_criteria_ctcv5} implements \href{https://ctep.cancer.gov/protocoldevelopment/electronic_applications/ctc.htm}{Common Terminology Criteria for Adverse Events (CTCAE) v5.0}
\item \code{atoxgr_criteria_daids} implements
\href{https://rsc.niaid.nih.gov/sites/default/files/daidsgradingcorrectedv21.pdf}{Division of AIDS (DAIDS) Table for Grading the Severity of Adult and Pediatric Adverse Events}

The metadata should have the following variables:
\item \code{TERM}: variable to hold the term describing the criteria applied to a particular lab test,
eg. "Anemia" or "INR Increased". Note: the variable is case insensitive.
\item \code{DIRECTION}: variable to hold the direction of the abnormality of a particular lab test
value. "L" is for LOW values, "H" is for HIGH values. Note: the variable is case insensitive.
\item \code{SI_UNIT_CHECK}: variable to hold unit of particular lab test. Used to check against input data
if criteria is based on absolute values.
\item \code{VAR_CHECK}: variable to hold comma separated list of variables used in criteria. Used to check
against input data that variables exist.
\item \code{GRADE_CRITERIA_CODE}: variable to hold code that creates grade based on defined criteria.
\item \code{FILTER}: Required only for DAIDS grading, specifies \code{admiral} code to filter the lab data
based on a subset of subjects (e.g. AGE > 18 YEARS)
}}

\item{criteria_direction}{Direction (L= Low, H = High) of toxicity grade.

Permitted Values: "L", "H"}

\item{get_unit_expr}{An expression providing the unit of the parameter

The result is used to check the units of the input parameters. Compared with
\code{SI_UNIT_CHECK} in metadata (see \code{meta_criteria} parameter).

Permitted Values: A variable containing unit from the input dataset, or a function call,
for example, \code{get_unit_expr = extract_unit(PARAM)}.}

\item{signif_dig}{Number of significant digits to use when comparing a lab value against another
value.

Significant digits used to avoid floating point discrepancies when comparing numeric values.}
}
\value{
The input dataset with the character variable added
}
\description{
Derives a character lab grade based on severity/toxicity criteria.
}
\details{
\code{new_var} is derived with values NA, "0", "1", "2", "3", "4", where "4" is the most
severe grade
\itemize{
\item "4" is where the lab value satisfies the criteria for grade 4.
\item "3" is where the lab value satisfies the criteria for grade 3.
\item "2" is where the lab value satisfies the criteria for grade 2.
\item "1" is where the lab value satisfies the criteria for grade 1.
\item "0" is where a grade can be derived and is not grade "1", "2", "3" or "4".
\item NA is where a grade cannot be derived.
}
}
\examples{
library(tibble)

data <- tribble(
  ~ATOXDSCL,                    ~AVAL, ~ANRLO, ~ANRHI, ~PARAM,
  "Hypoglycemia",               119,   4,      7,      "Glucose (mmol/L)",
  "Lymphocyte count decreased", 0.7,   1,      4,      "Lymphocytes Abs (10^9/L)",
  "Anemia",                     129,   120,    180,    "Hemoglobin (g/L)",
  "White blood cell decreased", 10,    5,      20,     "White blood cell (10^9/L)",
  "White blood cell decreased", 15,    5,      20,     "White blood cell (10^9/L)",
  "Anemia",                     140,   120,    180,    "Hemoglobin (g/L)"
)

derive_var_atoxgr_dir(data,
  new_var = ATOXGRL,
  tox_description_var = ATOXDSCL,
  meta_criteria = atoxgr_criteria_ctcv5,
  criteria_direction = "L",
  get_unit_expr = extract_unit(PARAM)
)

data <- tribble(
  ~ATOXDSCH,                     ~AVAL,  ~ANRLO,   ~ANRHI, ~PARAM,
  "CPK increased",               129,    0,        30,     "Creatine Kinase (U/L)",
  "Lymphocyte count increased",  4,      1,        4,      "Lymphocytes Abs (10^9/L)",
  "Lymphocyte count increased",  2,      1,        4,      "Lymphocytes Abs (10^9/L)",
  "CPK increased",               140,    120,      180,    "Creatine Kinase (U/L)"
)

derive_var_atoxgr_dir(data,
  new_var = ATOXGRH,
  tox_description_var = ATOXDSCH,
  meta_criteria = atoxgr_criteria_ctcv5,
  criteria_direction = "H",
  get_unit_expr = extract_unit(PARAM)
)
}
\seealso{
BDS-Findings Functions that returns variable appended to dataset: 
\code{\link{derive_basetype_records}()},
\code{\link{derive_var_analysis_ratio}()},
\code{\link{derive_var_anrind}()},
\code{\link{derive_var_atoxgr}()},
\code{\link{derive_var_base}()},
\code{\link{derive_var_chg}()},
\code{\link{derive_var_ontrtfl}()},
\code{\link{derive_var_pchg}()},
\code{\link{derive_var_shift}()}
}
\concept{der_bds_findings}
\keyword{der_bds_findings}
