% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_derivation.R
\name{call_derivation}
\alias{call_derivation}
\title{Call a Single Derivation Multiple Times}
\usage{
call_derivation(dataset = NULL, derivation, variable_params, ...)
}
\arguments{
\item{dataset}{The input dataset}

\item{derivation}{The derivation function to call}

\item{variable_params}{A \code{list} of arguments that are different across iterations.
Each set of arguments must be created using \code{\link[=params]{params()}}.}

\item{...}{Any number of \emph{named} arguments that are fixed across iterations.
If a parameter is specified both inside \code{variable_params} and \code{...} then
the value in \code{variable_params} overwrites the one in \code{...}}
}
\value{
The input dataset with additional records/variables added depending on
which \code{derivation} has been used.
}
\description{
Call a single derivation multiple times with some parameters being fixed across
iterations and others varying.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(ae)
data(adsl)

adae <- ae[sample(1:nrow(ae), 1000), ] \%>\%
  left_join(adsl, by = "USUBJID") \%>\%
  select(USUBJID, AESTDTC, AEENDTC, TRTSDT, TRTEDT)

## While `derive_vars_dt()` can only add one variable at a time, using `call_derivation()`
## one can add multiple variables in one go
call_derivation(
  dataset = adae,
  derivation = derive_vars_dt,
  variable_params = list(
    params(dtc = AESTDTC, date_imputation = "first", new_vars_prefix = "AST"),
    params(dtc = AEENDTC, date_imputation = "last", new_vars_prefix = "AEN")
  ),
  min_dates = vars(TRTSDT),
  max_dates = vars(TRTEDT)
)

## The above call using `call_derivation()` is equivalent to the following
adae \%>\%
  derive_vars_dt(
    new_vars_prefix = "AST",
    dtc = AESTDTC,
    date_imputation = "first",
    min_dates = vars(TRTSDT),
    max_dates = vars(TRTEDT)
  ) \%>\%
  derive_vars_dt(
    new_vars_prefix = "AEN",
    dtc = AEENDTC,
    date_imputation = "last",
    min_dates = vars(TRTSDT),
    max_dates = vars(TRTEDT)
  )
}
\seealso{
\code{\link[=params]{params()}}
}
\author{
Thomas Neitmann, Stefan Bundfuss
}
\keyword{user_utility}
