% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_last_dose.R
\name{derive_vars_last_dose}
\alias{derive_vars_last_dose}
\title{Derive Last Dose}
\usage{
derive_vars_last_dose(
  dataset,
  dataset_ex,
  filter_ex = NULL,
  by_vars = vars(STUDYID, USUBJID),
  dose_id = vars(),
  dose_date,
  analysis_date,
  single_dose_condition = (EXDOSFRQ == "ONCE"),
  new_vars = NULL,
  traceability_vars = NULL
)
}
\arguments{
\item{dataset}{Input dataset.
The variables specified by the \code{by_vars} and \code{analysis_date} parameters are expected.}

\item{dataset_ex}{Input EX dataset.
The variables specified by the \code{by_vars}, \code{dose_date}, \code{new_vars} parameters,
and source variables from \code{traceability_vars} parameter are expected.}

\item{filter_ex}{Filtering condition applied to EX dataset.
For example, it can be used to filter for valid dose.
Defaults to NULL.}

\item{by_vars}{Variables to join by (created by \code{dplyr::vars}).}

\item{dose_id}{Variables to identify unique dose (created by \code{dplyr::vars}).
Defaults to empty \code{vars()}.}

\item{dose_date}{The EX dose date variable.}

\item{analysis_date}{The analysis date variable.}

\item{single_dose_condition}{The condition for checking if \code{dataset_ex} is single dose. An error
is issued if the condition is not true. Defaults to \code{(EXDOSFRQ == "ONCE")}.}

\item{new_vars}{Variables to keep from \code{dataset_ex}, with the option to rename. Can either
be variables created by \code{dplyr::vars} (e.g. \code{vars(VISIT)}), or named list returned by \code{\link[=vars]{vars()}}
(e.g. \code{vars(LSTEXVIS = VISIT)}). If set to \code{NULL}, then all variables from \code{dataset_ex} are
kept without renaming.
Defaults to \code{NULL}.}

\item{traceability_vars}{A named list returned by \code{\link[=vars]{vars()}} listing the traceability variables,
e.g. \code{vars(LDOSEDOM = "EX", LDOSESEQ = EXSEQ)}.
The left-hand side (names of the list elements) gives the names of the traceability variables
in the returned dataset.
The right-hand side (values of the list elements) gives the values of the traceability variables
in the returned dataset.
These can be either strings or symbols referring to existing variables.}
}
\value{
Input dataset with EX source variables from last dose added.
}
\description{
Add EX source variables from last dose to the input dataset.
}
\details{
All date (date-time) variables can be characters in standard ISO format or
of date / date-time class.
For ISO format, see \code{\link{impute_dtc}} - parameter \code{dtc} for further details.
When doing date comparison to identify last dose, date-time imputations are done as follows:
\itemize{
\item \code{dose_date}: no date imputation, time imputation to \code{00:00:00} if time is missing.
\item \code{analysis_date}: no date imputation, time imputation to \code{23:59:59} if time is missing.
}

The last dose records are identified as follows:
\enumerate{
\item The \code{dataset_ex} is filtered using \code{filter_ex}, if provided.
This is useful for, for example, filtering for valid dose only.
\item The datasets \code{dataset} and \code{dataset_ex} are joined using \code{by_vars}.
\item The last dose is identified:
the last dose is the EX record with maximum date where \code{dose_date} is lower to or equal to
\code{analysis_date}, subject to both date values are non-NA.
The last dose is identified per \code{by_vars}.
If multiple EX records exist for the same \code{dose_date}, then either \code{dose_id}
needs to be supplied (e.g. \code{dose_id = vars(EXSEQ)}) to identify unique records,
or an error is issued. When \code{dose_id} is supplied, the last EX record from the same \code{dose_date}
sorted by \code{dose_id} will be used to identify last dose.
\item The EX source variables (as specified in \code{new_vars}) from last dose are appended to the
\code{dataset} and returned to the user.
}

This function only works correctly for EX dataset with a structure of single dose per row.
If your study EX dataset has multiple doses per row, use \verb{expansion_function_name??} to
transform the EX dataset into single dose per row structure before calling
\code{derive_vars_last_dose}.

If variables (other than those specified in \code{by_vars}) exist in both \code{dataset} and \code{dataset_ex},
then join cannot be performed properly and an error is issued. To resolve the error, use
\code{new_vars} to either keep variables unique to \code{dataset_ex}, or use this option to rename
variables from \code{dataset_ex} (e.g. \code{new_vars = vars(LSTEXVIS = VISIT)}).
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(ae)
data(ex_single)

ae \%>\%
  head(100) \%>\%
  derive_vars_last_dose(
    head(ex_single, 100),
    filter_ex = (EXDOSE > 0 | (EXDOSE == 0 & grepl("PLACEBO", EXTRT))) &
      nchar(EXENDTC) >= 10,
    new_vars = vars(EXDOSE, EXTRT, EXSEQ, EXENDTC, VISIT),
    dose_date = EXENDTC,
    analysis_date = AESTDTC,
    single_dose_condition = (EXSTDTC == EXENDTC)
  ) \%>\%
  select(STUDYID, USUBJID, AESEQ, AESTDTC, EXDOSE, EXTRT, EXENDTC, EXSEQ, VISIT)

# or with traceability variables
ae \%>\%
  head(100) \%>\%
  derive_vars_last_dose(
    head(ex_single, 100),
    filter_ex = (EXDOSE > 0 | (EXDOSE == 0 & grepl("PLACEBO", EXTRT))) &
      nchar(EXENDTC) >= 10,
    new_vars = vars(EXDOSE, EXTRT, EXSEQ, EXENDTC, VISIT),
    dose_date = EXENDTC,
    analysis_date = AESTDTC,
    single_dose_condition = (EXSTDTC == EXENDTC),
    traceability_vars = dplyr::vars(LDOSEDOM = "EX", LDOSESEQ = EXSEQ, LDOSEVAR = "EXENDTC")
  ) \%>\%
  select(STUDYID, USUBJID, AESEQ, AESTDTC, EXDOSE, EXTRT, EXENDTC, LDOSEDOM, LDOSESEQ, LDOSEVAR)

}
\author{
Ondrej Slama, Annie Yang
}
\keyword{adam}
\keyword{derivation}
\keyword{user_utility}
