% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{signal_duplicate_records}
\alias{signal_duplicate_records}
\title{Signal Duplicate Records}
\usage{
signal_duplicate_records(
  dataset,
  by_vars,
  msg = paste("Dataset contains duplicate records with respect to",
    enumerate(vars2chr(by_vars))),
  cnd_type = "error"
)
}
\arguments{
\item{dataset}{A data frame}

\item{by_vars}{A list of variables created using \code{vars()} identifying groups of
records in which to look for duplicates}

\item{msg}{The condition message}

\item{cnd_type}{Type of condition to signal when detecting duplicate records.
One of \code{"message"}, \code{"warning"} or \code{"error"}. Default is \code{"error"}.}
}
\value{
No return value, called for side effects
}
\description{
Signal Duplicate Records
}
\examples{
data(adsl)

# Duplicate the first record
adsl <- rbind(adsl[1L, ], adsl)

signal_duplicate_records(adsl, vars(USUBJID), cnd_type = "message")
}
\author{
Thomas Neitmann
}
\keyword{dev_utility}
