% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_query_data.R
\name{assert_terms}
\alias{assert_terms}
\title{Asserts Requirements for Terms for Queries}
\usage{
assert_terms(
  terms,
  expect_query_name = FALSE,
  expect_query_id = FALSE,
  source_text
)
}
\arguments{
\item{terms}{Terms provided by user}

\item{expect_query_name}{Is the \code{QUERY_NAME} column expected?}

\item{expect_query_id}{Is the \code{QUERY_ID} column expected?}

\item{source_text}{Text describing the source of the terms, e.g., \verb{"the data frame provided for the }definition\verb{ element"}.}
}
\value{
An error is issued if
\itemize{
\item \code{terms} is not a data frame,
\item \code{terms} has zero observations,
\item the \code{TERM_LEVEL} variable is not in \code{terms},
\item neither the \code{TERM_NAME} nor the \code{TERM_ID} variable is in \code{terms},
\item \code{expect_query_name == TRUE} and the \code{QUERY_NAME} variable is not in \code{terms},
\item \code{expect_query_id == TRUE} and the \code{QUERY_ID} variable is not in \code{terms},
}
}
\description{
The function checks the requirements for terms for queries provided by the
user. The terms could have been provided directly in the query definition or
via a user provided function for accessing a SMQ or SDG database.
}
\examples{

try(
  assert_terms(
    terms = 42,
    source_text = "object provided by the `definition` element"
  )
)
}
\seealso{
\code{\link[=create_query_data]{create_query_data()}}, \code{\link[=query]{query()}}

Source Specifications: 
\code{\link{assert_db_requirements}()},
\code{\link{assert_valid_queries}()},
\code{\link{basket_select}()},
\code{\link{censor_source}()},
\code{\link{date_source}()},
\code{\link{death_event}},
\code{\link{dthcaus_source}()},
\code{\link{event_source}()},
\code{\link{extend_source_datasets}()},
\code{\link{filter_date_sources}()},
\code{\link{format.basket_select}()},
\code{\link{list_tte_source_objects}()},
\code{\link{params}()},
\code{\link{query}()},
\code{\link{sdg_select}()},
\code{\link{smq_select}()},
\code{\link{tte_source}()},
\code{\link{validate_basket_select}()},
\code{\link{validate_query}()}
}
\author{
Stefan Bundfuss
}
\concept{source_specifications}
\keyword{source_specifications}
