% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_atc.R
\name{derive_vars_atc}
\alias{derive_vars_atc}
\title{Derive ATC Class Variables}
\usage{
derive_vars_atc(
  dataset,
  dataset_facm,
  by_vars = exprs(!!!get_admiral_option("subject_keys"), CMREFID = FAREFID),
  id_vars = NULL,
  value_var = FASTRESC
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.

\describe{
\item{Default value}{none}
}}

\item{dataset_facm}{FACM dataset

The variables specified by the \code{by_vars}, \code{id_vars}, and \code{value_var}
arguments and \code{FATESTCD} are required. The variables \code{by_vars}, \code{id_vars},
and \code{FATESTCD} must be a unique key.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

Keys used to merge \code{dataset_facm} with \code{dataset}.

\describe{
\item{Default value}{\code{exprs(!!!get_admiral_option("subject_keys"), CMREFID = FAREFID)}}
}}

\item{id_vars}{ID variables

Variables (excluding by_vars) that uniquely identify each observation in \code{dataset_merge}.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{value_var}{The variable of \code{dataset_facm} containing the values of the
transposed variables

\describe{
\item{Default value}{\code{FASTRESC}}
}}
}
\value{
The input dataset with ATC variables added
}
\description{
Add Anatomical Therapeutic Chemical class variables from \code{FACM} to \code{ADCM}.

\strong{Note:} This is a wrapper function for the more generic \code{derive_vars_transposed()}.
}
\examples{
library(tibble)

cm <- tribble(
  ~STUDYID,  ~USUBJID,       ~CMGRPID, ~CMREFID,  ~CMDECOD,
  "STUDY01", "BP40257-1001", "14",     "1192056", "PARACETAMOL",
  "STUDY01", "BP40257-1001", "18",     "2007001", "SOLUMEDROL",
  "STUDY01", "BP40257-1002", "19",     "2791596", "SPIRONOLACTONE"
)
facm <- tribble(
  ~STUDYID,  ~USUBJID,       ~FAGRPID, ~FAREFID,  ~FATESTCD,  ~FASTRESC,
  "STUDY01", "BP40257-1001", "1",      "1192056", "CMATC1CD", "N",
  "STUDY01", "BP40257-1001", "1",      "1192056", "CMATC2CD", "N02",
  "STUDY01", "BP40257-1001", "1",      "1192056", "CMATC3CD", "N02B",
  "STUDY01", "BP40257-1001", "1",      "1192056", "CMATC4CD", "N02BE",
  "STUDY01", "BP40257-1001", "1",      "2007001", "CMATC1CD", "D",
  "STUDY01", "BP40257-1001", "1",      "2007001", "CMATC2CD", "D10",
  "STUDY01", "BP40257-1001", "1",      "2007001", "CMATC3CD", "D10A",
  "STUDY01", "BP40257-1001", "1",      "2007001", "CMATC4CD", "D10AA",
  "STUDY01", "BP40257-1001", "2",      "2007001", "CMATC1CD", "D",
  "STUDY01", "BP40257-1001", "2",      "2007001", "CMATC2CD", "D07",
  "STUDY01", "BP40257-1001", "2",      "2007001", "CMATC3CD", "D07A",
  "STUDY01", "BP40257-1001", "2",      "2007001", "CMATC4CD", "D07AA",
  "STUDY01", "BP40257-1001", "3",      "2007001", "CMATC1CD", "H",
  "STUDY01", "BP40257-1001", "3",      "2007001", "CMATC2CD", "H02",
  "STUDY01", "BP40257-1001", "3",      "2007001", "CMATC3CD", "H02A",
  "STUDY01", "BP40257-1001", "3",      "2007001", "CMATC4CD", "H02AB",
  "STUDY01", "BP40257-1002", "1",      "2791596", "CMATC1CD", "C",
  "STUDY01", "BP40257-1002", "1",      "2791596", "CMATC2CD", "C03",
  "STUDY01", "BP40257-1002", "1",      "2791596", "CMATC3CD", "C03D",
  "STUDY01", "BP40257-1002", "1",      "2791596", "CMATC4CD", "C03DA"
)

derive_vars_atc(cm, facm, id_vars = exprs(FAGRPID))
}
\seealso{
\code{\link[=derive_vars_transposed]{derive_vars_transposed()}}

OCCDS Functions: 
\code{\link{derive_var_trtemfl}()},
\code{\link{derive_vars_query}()},
\code{\link{get_terms_from_db}()}
}
\concept{der_occds}
\keyword{der_occds}
