% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_data_frame}
\alias{assert_data_frame}
\title{Is an Argument a Data Frame?}
\usage{
assert_data_frame(
  arg,
  required_vars = NULL,
  check_is_grouped = TRUE,
  optional = FALSE
)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{required_vars}{A list of variables created using \code{exprs()}}

\item{check_is_grouped}{Throw an error is \code{dataset} is grouped? Defaults to \code{TRUE}.}

\item{optional}{Is the checked argument optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a data frame or if \code{arg}
is a data frame but misses any variable specified in \code{required_vars}. Otherwise,
the input is returned invisibly.
}
\description{
Checks if an argument is a data frame and (optionally) whether is contains
a set of required variables
}
\examples{
library(pharmaversesdtm)
library(dplyr, warn.conflicts = FALSE)
library(rlang)
data(dm)

example_fun <- function(dataset) {
  assert_data_frame(dataset, required_vars = exprs(STUDYID, USUBJID))
}

example_fun(dm)

try(example_fun(select(dm, -STUDYID)))

try(example_fun("Not a dataset"))
}
\seealso{
Checks for valid input and returns warning or errors messages: 
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_expr}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_param_does_not_exist}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
