% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_pd.R
\name{filter_pd}
\alias{filter_pd}
\title{Filter up to First PD (Progressive Disease) Date}
\usage{
filter_pd(
  dataset,
  filter,
  source_pd,
  source_datasets,
  subject_keys = vars(STUDYID, USUBJID)
)
}
\arguments{
\item{dataset}{Input dataset

The variables \code{ADT} and those specified by \code{subject_keys} are expected.}

\item{filter}{Filter condition for restricting the input dataset}

\item{source_pd}{A \code{admiral::date_source()} object providing the date of first PD

For each subject the first date (\code{date} field) in the provided dataset
(\code{dataset_name} field) restricted by \code{filter} field is considered as first
PD date.}

\item{source_datasets}{A named list of data sets is expected.

The name must match the name provided by the \code{dataset_name} field of the
\code{admiral::date_source()} object specified for \code{source_pd}.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of symbols created using \code{vars()} is expected.}
}
\value{
A subset of the input dataset
}
\description{
Filter a dataset to only include the source parameter records up to and
including the first PD (progressive disease). These records are passed to
downstream derivations regarding responses such as BOR (best overall
response).
}
\details{
\enumerate{
\item The input dataset (\code{dataset}) is restricted by \code{filter}.
\item For each subject the first PD date is derived as the first date
(\code{source_pd$date}) in the source pd dataset
(\code{source_datasets[[source_pd$dataset_name]]}) restricted by
\code{source_pd$filter}.
\item The restricted input dataset is restricted to records up to first PD date.
Records matching first PD date are included. For subject without any first PD
date, all records are included.
}
}
\examples{

library(dplyr)
library(lubridate)
library(admiral)
library(admiralonco)

# Filter OVR records up to first PD, first PD date provided in separate BDS dataset (adevent)
adrs <- tibble::tribble(
  ~STUDYID,       ~USUBJID,      ~PARAMCD, ~AVALC, ~ADT,         ~ANL01FL,
  "CDISCPILOT01", "01-701-1015", "OVR",    "CR",   "2016-01-25", "Y",
  "CDISCPILOT01", "01-701-1015", "OVR",    "SD",   "2016-02-22", NA_character_,
  "CDISCPILOT01", "01-701-1015", "OVR",    "PD",   "2016-02-22", "Y",
  "CDISCPILOT01", "01-701-1015", "BOR",    "CR",   "2016-01-25", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "SD",   "2015-12-07", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "PD",   "2016-04-25", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "PD",   "2016-06-25", "Y",
  "CDISCPILOT01", "01-701-1034", "BOR",    "SD",   "2015-12-07", "Y",
  "CDISCPILOT01", "01-701-1035", "OVR",    "SD",   "2016-04-25", "Y",
  "CDISCPILOT01", "01-701-1035", "OVR",    "PR",   "2016-06-25", "Y",
  "CDISCPILOT01", "01-701-1035", "BOR",    "PR",   "2016-06-25", "Y"
) \%>\% mutate(
  ADT = as_date(ADT)
)

adevent <- tibble::tribble(
  ~STUDYID,       ~USUBJID,      ~PARAMCD, ~AVALC, ~ADT,
  "CDISCPILOT01", "01-701-1015", "PD",     "Y",    "2016-02-22",
  "CDISCPILOT01", "01-701-1034", "PD",     "Y",    "2016-04-25"
) \%>\% mutate(
  ADT = as_date(ADT)
)

pd <- date_source(
  dataset_name = "adevent",
  date = ADT,
  filter = PARAMCD == "PD"
)

filter_pd(
  dataset = adrs,
  filter = PARAMCD == "OVR" & ANL01FL == "Y",
  source_pd = pd,
  source_datasets = list(adevent = adevent)
)

# Filter OVR records up to first PD, first PD date provided in ADSL dataset
adsl <- tibble::tribble(
  ~STUDYID,       ~USUBJID,      ~PDDT,
  "CDISCPILOT01", "01-701-1015", "2016-02-22",
  "CDISCPILOT01", "01-701-1034", "2016-04-25",
  "CDISCPILOT01", "01-701-1035", ""
) \%>\% mutate(
  PDDT = as_date(PDDT)
)

pd <- date_source(
  dataset_name = "adsl",
  date = PDDT
)

filter_pd(
  dataset = adrs,
  filter = PARAMCD == "OVR" & ANL01FL == "Y",
  source_pd = pd,
  source_datasets = list(adsl = adsl)
)

# Filter OVR records up to first PD, first PD date provided in input dataset (PD parameter)
adrs <- tibble::tribble(
  ~STUDYID,       ~USUBJID,      ~PARAMCD, ~AVALC, ~ADT,         ~ANL01FL,
  "CDISCPILOT01", "01-701-1015", "OVR",    "CR",   "2016-01-25", "Y",
  "CDISCPILOT01", "01-701-1015", "OVR",    "SD",   "2016-02-22", NA_character_,
  "CDISCPILOT01", "01-701-1015", "OVR",    "PD",   "2016-02-22", "Y",
  "CDISCPILOT01", "01-701-1015", "BOR",    "CR",   "2016-01-25", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "SD",   "2015-12-07", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "PD",   "2016-04-25", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "PD",   "2016-06-25", "Y",
  "CDISCPILOT01", "01-701-1034", "BOR",    "SD",   "2015-12-07", "Y",
  "CDISCPILOT01", "01-701-1035", "OVR",    "SD",   "2016-04-25", "Y",
  "CDISCPILOT01", "01-701-1035", "OVR",    "PR",   "2016-06-25", "Y",
  "CDISCPILOT01", "01-701-1035", "BOR",    "PR",   "2016-06-25", "Y",
  "CDISCPILOT01", "01-701-1015", "PD",     "Y",    "2016-02-22", "Y",
  "CDISCPILOT01", "01-701-1034", "PD",     "Y",    "2016-04-25", "Y"
) \%>\% mutate(
  ADT = as_date(ADT)
)

pd <- date_source(
  dataset_name = "adrs",
  date = ADT,
  filter = PARAMCD == "PD"
)

filter_pd(
  dataset = adrs,
  filter = PARAMCD == "OVR" & ANL01FL == "Y",
  source_pd = pd,
  source_datasets = list(adrs = adrs)
)

# Filter OVR records up to first PD, first PD date derived from OVR records
adrs <- tibble::tribble(
  ~STUDYID,       ~USUBJID,      ~PARAMCD, ~AVALC, ~ADT,         ~ANL01FL,
  "CDISCPILOT01", "01-701-1015", "OVR",    "CR",   "2016-01-25", "Y",
  "CDISCPILOT01", "01-701-1015", "OVR",    "SD",   "2016-02-22", NA_character_,
  "CDISCPILOT01", "01-701-1015", "OVR",    "PD",   "2016-02-22", "Y",
  "CDISCPILOT01", "01-701-1015", "BOR",    "CR",   "2016-01-25", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "SD",   "2015-12-07", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "PD",   "2016-04-25", "Y",
  "CDISCPILOT01", "01-701-1034", "OVR",    "PD",   "2016-06-25", "Y",
  "CDISCPILOT01", "01-701-1034", "BOR",    "SD",   "2015-12-07", "Y",
  "CDISCPILOT01", "01-701-1035", "OVR",    "SD",   "2016-04-25", "Y",
  "CDISCPILOT01", "01-701-1035", "OVR",    "PR",   "2016-06-25", "Y",
  "CDISCPILOT01", "01-701-1035", "BOR",    "PR",   "2016-06-25", "Y"
) \%>\% mutate(
  ADT = as_date(ADT)
)

pd <- date_source(
  dataset_name = "adrs",
  date = ADT,
  filter = PARAMCD == "OVR" & ANL01FL == "Y" & AVALC == "PD"
)

filter_pd(
  dataset = adrs,
  filter = PARAMCD == "OVR" & ANL01FL == "Y",
  source_pd = pd,
  source_datasets = list(adrs = adrs)
)
}
\author{
Teckla Akinyi, Stefan Bundfuss
}
\concept{utils_fil}
\keyword{utils_fil}
