% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_crpr.R
\name{signal_crpr}
\alias{signal_crpr}
\title{Signal CR Records Followed by PR}
\usage{
signal_crpr(
  dataset,
  order,
  msg = "Dataset contains CR records followed by PR.",
  subject_keys = vars(STUDYID, USUBJID),
  check_type = "warning"
)
}
\arguments{
\item{dataset}{A data frame}

\item{order}{A list of variables created using \code{vars()} determining the order
or the records}

\item{msg}{The condition message}

\item{subject_keys}{Variables to uniquely identify a subject

A list of symbols created using \code{vars()} is expected.}

\item{check_type}{Type of message to issue when detecting PR after CR.

\emph{Permitted Values}: \code{"message"}, \code{"warning"} or \code{"error"}}
}
\value{
No return value, called for side effects
}
\description{
Signal CR Records Followed by PR
}
\examples{
library(tibble)
library(dplyr)
library(lubridate)
library(admiralonco)

adrs <- tribble(
  ~USUBJID, ~ADTC,        ~AVALC,
  "1",      "2020-01-01", "PR",
  "1",      "2020-02-01", "CR",
  "1",      "2020-02-16", "NE",
  "1",      "2020-03-01", "CR",
  "2",      "2020-02-06", "PR",
  "2",      "2020-02-16", "CR",
  "2",      "2020-03-30", "PR",
) \%>\%
  mutate(
    ADT = ymd(ADTC),
    STUDYID = "XX1234"
  )

signal_crpr(adrs, order = vars(ADT))
}
\seealso{
\code{\link[=get_crpr_dataset]{get_crpr_dataset()}}

Utilities for Dataset Checking: 
\code{\link{get_crpr_dataset}()}
}
\author{
Stefan Bundfuss
}
\concept{utils_ds_chk}
\keyword{utils_ds_chk}
