% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eigenstrat.R
\name{transversions_only}
\alias{transversions_only}
\title{Remove transversions (C->T and G->A substitutions)}
\usage{
transversions_only(data, outfile = tempfile(fileext = ".snp"))
}
\arguments{
\item{data}{EIGENSTRAT data object.}

\item{outfile}{Path to an output snp file with coordinates of excluded sites.}
}
\value{
Updated S3 EIGENSTRAT data object with an additional 'exclude' slot
    specifying the path to the set of SNPs to be removed from a downstream
    analysis.
}
\description{
Remove substitutions that are more likely to be a result of ancient DNA
damage (C->T and G->A substitutions).
}
\examples{
\dontrun{# download an example genomic data set and prepare it for analysis
snps <- eigenstrat(download_data(dirname = tempdir()))

# perform the calculation only on transversions
snps_tv <- transversions_only(snps)
results_d <- d(W = "French", X = "Dinka", Y = "Altai", Z = "Chimp", data = snps_tv)
}

}
