% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_designs.R
\docType{methods}
\name{get_lower_boundary_design}
\alias{get_lower_boundary_design}
\alias{get_upper_boundary_design}
\alias{get_lower_boundary_design,OneStageDesign-method}
\alias{get_lower_boundary_design,GroupSequentialDesign-method}
\alias{get_lower_boundary_design,TwoStageDesign-method}
\alias{get_upper_boundary_design,OneStageDesign-method}
\alias{get_upper_boundary_design,GroupSequentialDesign-method}
\alias{get_upper_boundary_design,TwoStageDesign-method}
\title{Boundary designs}
\usage{
get_lower_boundary_design(initial_design, ...)

get_upper_boundary_design(initial_design, ...)

\S4method{get_lower_boundary_design}{OneStageDesign}(initial_design,
  n1 = 1, c1_buffer = 2, ...)


  \S4method{get_lower_boundary_design}{GroupSequentialDesign}(initial_design,
  n1 = 1, n2_pivots = 1, c1_buffer = 2, c2_buffer = 2, ...)

\S4method{get_lower_boundary_design}{TwoStageDesign}(initial_design,
  n1 = 1, n2_pivots = 1, c1_buffer = 2, c2_buffer = 2, ...)

\S4method{get_upper_boundary_design}{OneStageDesign}(initial_design,
  n1 = 5 * initial_design@n1, c1_buffer = 2, ...)


  \S4method{get_upper_boundary_design}{GroupSequentialDesign}(initial_design,
  n1 = 5 * initial_design@n1, n2_pivots = 5 * initial_design@n2_pivots,
  c1_buffer = 2, c2_buffer = 2, ...)

\S4method{get_upper_boundary_design}{TwoStageDesign}(initial_design,
  n1 = 5 * initial_design@n1, n2_pivots = 5 * initial_design@n2_pivots,
  c1_buffer = 2, c2_buffer = 2, ...)
}
\arguments{
\item{initial_design}{The initial design}

\item{...}{optional arguments

The values \code{c1f} and \code{c1e} from the initial design are shifted
to \code{c1f - c1_buffer} and \code{c1e - c1_buffer} in
\code{get_lower_boundary_design}, respectively, to \cr
\code{c1f + c1_buffer} and \code{c1e + c1_buffer} in
\code{get_upper_boundary_design}.
This is handled analogously with \code{c2_pivots} and \code{c2_buffer}.}

\item{n1}{bound for the first-stage sample size n1}

\item{c1_buffer}{shift of the early-stopping boundaries from the initial ones}

\item{n2_pivots}{bound for the second-stage sample size n2}

\item{c2_buffer}{shift of the final decision boundary from the initial one}
}
\description{
The optimization method \code{\link{minimize}} is based on the package
\code{nloptr}. This requires upper and lower boundaries for optimization.
Such boundaries can be computed via \code{lower_boundary_design}
respectively \code{upper_boundary_design}.
They are implemented by default in \code{\link{minimize}}.
Note that \code{\link{minimize}} allows the user to define its own
boundary designs, too.
}
\examples{
initial_design <- TwoStageDesign(
  n1    = 25,
  c1f   = 0,
  c1e   = 2.5,
  n2    = 50,
  c2    = 1.96,
  order = 7L
  )
get_lower_boundary_design(initial_design)

}
