% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFit.R
\name{all_fit}
\alias{all_fit}
\alias{nmkbw}
\title{Refit \code{lmer} model using multiple optimizers}
\usage{
all_fit(m, meth_tab = cbind(optimizer = rep(c("bobyqa", "Nelder_Mead",
  "optimx", "nloptwrap", "nmkbw"), c(1, 1, 2, 2, 1)), method = c("", "",
  "nlminb", "L-BFGS-B", "NLOPT_LN_NELDERMEAD", "NLOPT_LN_BOBYQA", "")),
  verbose = TRUE, maxfun = 1e+06, ...)

nmkbw(fn, par, lower, upper, control)
}
\arguments{
\item{m}{a fitted model with \code{lmer}}

\item{meth_tab}{a matrix (or data.frame) with columns
- method the name of a specific optimization method to pass to the optimizer
(leave blank for built-in optimizers)
- optimizer the \code{optimizer} function to use}

\item{verbose}{print progress messages?}

\item{maxfun}{number of iterations to allow for the optimization rountine.}

\item{...}{further arguments passed to \code{\link{update.merMod}} such as \code{data}.}

\item{fn}{needed for \code{dfoptim::nmkb}}

\item{par}{needed for \code{dfoptim::nmkb}}

\item{lower}{needed for \code{dfoptim::nmkb}}

\item{upper}{needed for \code{dfoptim::nmkb}}

\item{control}{needed for \code{dfoptim::nmkb}}
}
\value{
a list of fitted \code{merMod} objects
}
\description{
Attempt to re-fit a [g]lmer model with a range of optimizers.
The default is to use all known optimizers for R that satisfy the
requirements (do not require explicit gradients, allow
box constraints), in four categories; (i) built-in
(\code{minqa::bobyqa}, \code{lme4::Nelder_Mead}), (ii) wrapped via optimx
(most of optimx's optimizers that allow box constraints require
an explicit gradient function to be specified; the two provided
here are really base R functions that can be accessed via optimx,
(iii) wrapped via nloptr, (iv) \code{dfoptim::nmkb}.
}
\details{
Needs packages \pkg{nloptr}, \pkg{optimx}, and \code{dfoptim} to try out all optimizers. \pkg{optimx} needs to be loaded explicitly using \code{library} or \code{require} (see examples).

\code{nmkbw} is a simple wrapper function for fitting models with the corresponding optimizer. It needs to be exported for \code{lme4}, but should not be called directly by the user.
}
\note{
Very similar to the function of the same name that is part of \pkg{lme4}. The present function will be removed eventually in favor of the \pkg{lme4} function.
}
\examples{

\dontrun{

# basic usage
require(optimx)
gm1 <- glmer(cbind(incidence, size - incidence) ~ period + (1 | herd),
             data = cbpp, family = binomial)
gm_all <- all_fit(gm1)
t(sapply(gm_all,fixef)) ## extract fixed effects
sapply(gm_all,logLik) ## log-likelihoods
sapply(gm_all,getME,"theta") ## theta parameters
!sapply(gm_all,inherits,"try-error") ## was fit OK?


## for GLMMs:
require("mlmRev") # for data
gm1 <- mixed(use ~ age*urban + (1 | district), family = binomial, 
             data = Contraception, method = "LRT")
gm_all <- all_fit(gm1$full_model)
sapply(gm_all,logLik)

## use allFit in combination with expand.re = TRUE
data("sk2011.2") # see example("mixed")
sk2_aff <- droplevels(sk2011.2[sk2011.2$what == "affirmation",])
sk_m2 <- mixed(response ~ instruction*inference*type+(inference*type||id), sk2_aff,
               expand_re = TRUE)
sk_m2
sk_m2_allFit <- all_fit(sk_m2$full_model)
sk_m2_allFit # all fits fail

sk_m2_allFit <- all_fit(sk_m2$full_model, data = sk_m2$data) # works
t(sapply(sk_m2_allFit,fixef))
sapply(sk_m2_allFit,logLik)

}
}
\seealso{
slice, slice2D in the bbmle package
}
\author{
Ben Bolker, minor changes by Henrik Singmann
}
