% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_coord.r
\name{as_coord2d}
\alias{as_coord2d}
\alias{as_coord2d.angle}
\alias{as_coord2d.character}
\alias{as_coord2d.complex}
\alias{as_coord2d.Coord3D}
\alias{as_coord2d.data.frame}
\alias{as_coord2d.list}
\alias{as_coord2d.matrix}
\alias{as_coord2d.numeric}
\alias{as_coord2d.Coord2D}
\title{Cast to coord2d object}
\usage{
as_coord2d(x, ...)

\method{as_coord2d}{angle}(x, radius = 1, ...)

\method{as_coord2d}{character}(x, ...)

\method{as_coord2d}{complex}(x, ...)

\method{as_coord2d}{Coord3D}(
  x,
  permutation = c("xyz", "xzy", "yxz", "yzx", "zyx", "zxy"),
  ...,
  plane = as_plane3d("xy-plane"),
  scale = 0,
  alpha = angle(45, "degrees")
)

\method{as_coord2d}{data.frame}(x, ...)

\method{as_coord2d}{list}(x, ...)

\method{as_coord2d}{matrix}(x, ...)

\method{as_coord2d}{numeric}(x, y = rep_len(0, length(x)), ...)

\method{as_coord2d}{Coord2D}(x, ...)
}
\arguments{
\item{x}{An object that can be cast to a \link{Coord2D} class object
such as a matrix or data frame of coordinates.}

\item{...}{Further arguments passed to or from other methods}

\item{radius}{A numeric vector of radial distances.}

\item{permutation}{Either "xyz" (no permutation), "xzy" (permute y and z axes),
"yxz" (permute x and y axes), "yzx" (x becomes z, y becomes x, z becomes y),
"zxy" (x becomes y, y becomes z, z becomes x), "zyx" (permute x and z axes).
This permutation is applied before the (oblique) projection.}

\item{plane}{A \link{Plane3D} class object representing the plane
you wish to project to or an object coercible to one using \code{as_plane3d(plane, ...)}
such as "xy-plane", "xz-plane", or "yz-plane".}

\item{scale}{Oblique projection foreshortening scale factor.
A (degenerate) \code{0} value indicates an orthographic projection.
A value of \code{0.5} is used by a \dQuote{cabinet projection}
while a value of \code{1.0} is used by a \dQuote{cavalier projection}.}

\item{alpha}{Oblique projection angle (the angle the third axis is projected going off at).
An \code{\link[=angle]{angle()}} object or one coercible to one with \code{as_angle(alpha, ...)}.
Popular angles are 45 degrees, 60 degrees, and \code{arctangent(2)} degrees.}

\item{y}{Numeric vector of y-coordinates to be used.}
}
\value{
A \link{Coord2D} class object
}
\description{
\code{as_coord2d()} casts to a \link{Coord2D} class object
}
\examples{
df <- data.frame(x = sample.int(10, 3),
                 y = sample.int(10, 3))
as_coord2d(df)
as_coord2d(complex(real = 3, imaginary = 2))
as_coord2d(angle(90, "degrees"), radius = 2)
as_coord2d(as_coord3d(1, 2, 2), alpha = degrees(90), scale = 0.5)
}
