% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{ag5_extract}
\alias{ag5_extract}
\alias{ag5_extract.numeric}
\alias{ag5_extract.data.frame}
\title{Extract AgERA5 data stored in a local hardrive}
\usage{
ag5_extract(coords, ..., path)

\method{ag5_extract}{numeric}(
  coords,
  dates,
  variable,
  statistic = NULL,
  time = NULL,
  celsius = FALSE,
  ...,
  path
)

\method{ag5_extract}{data.frame}(
  coords,
  lon = "lon",
  lat = "lat",
  start_date = "start_date",
  end_date = "end_date",
  variable,
  statistic = NULL,
  time = NULL,
  celsius = FALSE,
  ...,
  path
)
}
\arguments{
\item{coords}{numeric vector of length = 2 of the form (lon, lat), or a \code{data.frame} with required columns}

\item{...}{Other parameters}

\item{path}{\code{character} The path for the folder containing the AgERA5 files}

\item{dates}{\code{character} The dates for extracting the specified variable, a vector of length 1 extracts a single date, while
a vector of length 2 indicates the start and end dates.
or the column name in the case of \code{data.frame}}

\item{variable}{\code{character} The AgERA5 variable to extract, see details for available options}

\item{statistic}{\code{character} Only for some variables, see details for valid options}

\item{time}{Only for variable Relative-Humidity-2m, see details for valid options}

\item{celsius}{logical Only for variables "Temperature-Air-2m" and "2m_dewpoint_temperature".
If \code{TRUE} the values are converted from Kelvin to Celsius. Default is \code{FALSE}}

\item{lon}{\code{character} Column name of longitude values in the case of \code{data.frame}}

\item{lat}{\code{character} Column name of latitude values in the case of \code{data.frame}}

\item{start_date}{\code{character} Column name of start_date values in the case that coords is a \code{data.frame}}

\item{end_date}{\code{character} Column name of end_date values in the case that coords is a \code{data.frame}}
}
\value{
\code{numeric} vector with length equal to the number of dates between first and
second date. The returned vecter is a named vector, with requested dates as names.
If only one date is provided the function returns a \code{numeric} vector
with \code{length = 1}.
If \code{coords} is a \code{data.frame}, the function returns a \code{list} of
\code{numeric} vectors, each one corresponding to the rows in the input \code{data.frame}
}
\description{
Extract data from AgERA5 data files previously downloaded from the Copernicus Climate Data Store.
These functions use package 'terra' to read *.nc files and extract the requested data for a given location
and dates. If dates is one value it extracts a single observation for the specified variable and location.
If dates is a character vector of \code{length == 2}, it will extract a time series of the specified variable
and location, where the first dates value is the start date and the second the end date.
}
\section{Valid variable values}{
\itemize{
\item "cloud_cover"
\item "liquid_precipitation_duration_fraction"
\item "snow_thickness_lwe"
\item "Solar-Radiation-Flux"
\item "Temperature-Air-2m"
\item "2m_dewpoint_temperature"
\item "Precipitation-Flux"
\item "solid_precipitation_duration_fraction"
\item "snow_thickness"
\item "vapour_pressure"
\item "10m_wind_speed"
\item "Relative-Humidity-2m"
}
}

\section{Valid statistics for variable "Temperature-Air-2m"}{
\itemize{
\item Max-24h
\item Mean-24h
\item 24_hour_minimum
\item Max-Day-Time
\item Mean-Day-Time
\item Mean-Night-Time
\item Min-Night-Time}
}

\section{Variables that require statistic}{
For the following variables, only "24_hour_mean" statistic is available,
but should be explicitly indicated.
\itemize{
\item cloud_cover
\item snow_thickness_lwe
\item 2m_dewpoint_temperature
\item snow_thickness
\item vapour_pressure
\item 10m_wind_speed
}
}

\section{Valid time values for variable "Relative-Humidity-2m"}{
\itemize{
\item 06h
\item 09h
\item 12h
\item 15h
\item 18h
}
}

\examples{
\dontrun{
temp <- ag5_extract(coords = c(lon = 35.72636, lat = -2.197162),
                      dates = "1991-04-22",
                      variable = "Temperature-Air-2m",
                      statistic = "Max-Day-Time",
                      path = "C:/temperature_data/")
}

}
\references{
Temperature conversion is made accordingly to:
Preston-Thomas, H. (1990). The International Temperature Scale of 1990 (ITS-90).
Metrologia, 27(1), 3-10. doi:10.1088/0026-1394/27/1/002
}
