% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrib-pareto2-adtest.R
\name{pareto2_test_ad}
\alias{pareto2_test_ad}
\title{Anderson-Darling Test for the Pareto Type-II Distribution}
\usage{
pareto2_test_ad(x, s = 1)
}
\arguments{
\item{x}{a non-negative numeric vector of data values}

\item{s}{the known scale parameter, \eqn{s>0}}
}
\value{
A list of the class \code{htest} is returned,
see \code{\link{exp_test_ad}}.
}
\description{
Performs an approximate Anderson-Darling goodness-of-fit
test, which verifies the null hypothesis:
Data follow a Pareto-Type II distribution.
}
\details{
We know that if \eqn{X} follows a Pareto-Type II distribution
with shape parameter \eqn{k}, then \eqn{log(1+X/s)} follows an
exponential distribution with parameter \eqn{k}.
Thus, this function transforms the input vector,
and performs the same steps as \code{\link{exp_test_ad}}.
}
\seealso{
Other Pareto2: \code{\link{pareto2_estimate_mle}},
  \code{\link{pareto2_estimate_mmse}},
  \code{\link{pareto2_test_f}}, \code{\link{rpareto2}}

Other Tests: \code{\link{exp_test_ad}},
  \code{\link{pareto2_test_f}}
}
\concept{Pareto2}
\concept{Tests}
